/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.values;

import java.util.Collection;
import org.antlr.runtime.tree.Tree;
import org.simantics.databoard.binding.Binding;
import org.simantics.graph.compiler.internal.ltk.ISource;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.ltk.antlr.ANTLRUtils;
import org.simantics.graph.compiler.internal.store.IPreValue;
import org.simantics.graph.compiler.internal.translation.DataValueTranslator;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;

public class TreeValue
implements IPreValue {
    ISource source;
    Tree tree;

    public TreeValue(ISource source, Tree tree) {
        this.source = source;
        this.tree = tree;
    }

    @Override
    public Object toValue(Binding binding, Collection<Problem> problems) {
        return new DataValueTranslator(this.source, problems).translate(this.tree, binding);
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    public Path getDefaultType(Paths paths) {
        Tree b = this.tree;
        while (b.getType() == 50 && b.getChildCount() == 1) {
            b = b.getChild(0);
        }
        switch (b.getType()) {
            case 26: {
                return paths.Integer;
            }
            case 18: {
                return paths.Double;
            }
            case 44: {
                return paths.String;
            }
            case 16: 
            case 49: {
                return paths.Boolean;
            }
            case 63: {
                return paths.Variant;
            }
            case 4: {
                if (b.getChildCount() <= 0) break;
                switch (b.getChild(0).getType()) {
                    case 18: 
                    case 26: {
                        int i = 0;
                        while (i < b.getChildCount()) {
                            if (b.getChild(i).getType() == 18) {
                                return paths.DoubleArray;
                            }
                            ++i;
                        }
                        return paths.IntegerArray;
                    }
                    case 44: {
                        return paths.StringArray;
                    }
                    case 16: 
                    case 49: {
                        return paths.BooleanArray;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Location getLocation() {
        return ANTLRUtils.location(this.source, this.tree);
    }

    public String toString() {
        return this.tree.getText();
    }
}

