package org.simantics.graph.compiler.internal.templates;

import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;

public class TemplateDefinitionStore implements IStore {
	TIntObjectHashMap<TemplateDefinition> templateDefinitions;
	TIntHashSet collisions = new TIntHashSet(); 

	public TemplateDefinitionStore(TIntObjectHashMap<TemplateDefinition> templateDefinitions) {
		this.templateDefinitions = templateDefinitions;
	}
	
	public TemplateDefinitionStore() {
		this(new TIntObjectHashMap<TemplateDefinition>());
	}

	@Override
	public void map(final TIntIntHashMap map) {
		templateDefinitions = IndexMappingUtils.map(map, templateDefinitions, collisions);
		templateDefinitions.forEachValue(new TObjectProcedure<TemplateDefinition>() {			
			@Override
			public boolean execute(TemplateDefinition template) {
				template.map(map);
				return true;
			}
		});
	}
	
	public void forTemplateDefinitions(TIntObjectProcedure<TemplateDefinition> proc) {
		templateDefinitions.forEachEntry(proc);
	}

	public void add(int subject, TemplateDefinition templateDefinition) {
		templateDefinitions.put(subject, templateDefinition);
	}

	public boolean isEmpty() {
		return templateDefinitions.isEmpty();
	}
	
	public TIntHashSet getCollisions() {
		return collisions;
	}
}
