/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.Functions;

public class DocumentPropertyKeys
extends ResourceAsyncRead<List<String>> {
    public DocumentPropertyKeys(Resource resource) {
        super(resource);
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<List<String>> procedure) {
        final ArrayList<String> result = new ArrayList<String>();
        final DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        try {
            if (graph.hasStatement(this.resource, DOC.Properties_dataDefinitions)) {
                result.add("dataDefinitions");
            }
        }
        catch (ServiceException e) {
            Functions.LOGGER.info(e.getMessage(), (Throwable)e);
        }
        graph.forEachDirectPredicate(this.resource, (AsyncProcedure)new AsyncProcedure<Set<Resource>>(){

            public void execute(AsyncReadGraph graph, Set<Resource> predicates) {
                for (Resource predicate : predicates) {
                    try {
                        PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
                        if (info.isHasProperty && info.hasClassification("http://www.simantics.org/Documentation-1.2/Document/AttributeRelation")) {
                            result.add(info.name);
                            continue;
                        }
                        Resource definition = graph.getPossibleObject(predicate, DOC.Document_definesAttributeRelation);
                        if (definition == null) continue;
                        PropertyInfo info2 = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(definition));
                        result.add(info2.name);
                    }
                    catch (DatabaseException e) {
                        Functions.LOGGER.info(e.getMessage(), (Throwable)e);
                    }
                }
                procedure.execute(graph, (Object)result);
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                Functions.LOGGER.info(throwable.getMessage(), throwable);
                procedure.exception(graph, throwable);
            }
        });
    }
}

