package org.simantics.document.server.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationRequest;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.structural2.scl.FindPossibleComponentTypeRequest;
import org.simantics.utils.datastructures.Pair;

abstract public class ServerSCLValueRequestBase<CompilationContext extends AbstractExpressionCompilationContext> extends AbstractExpressionCompilationRequest<CompilationContext, Object> {

    static Pair<Resource,Resource> getComponentTypeAndRoot(ReadGraph graph, Resource component, Resource literal)  throws DatabaseException {
        if(component != null) {
            Resource type = graph.syncRequest(new FindPossibleComponentTypeRequest(component));
            if(type != null) {
                Resource root = graph.syncRequest(new IndexRoot(type));
                return Pair.make(type, root);
            } else {
                Resource doc = graph.syncRequest(new PossibleTypedParent(component, DocumentationResource.getInstance(graph).Document));
                if(doc != null) {
                    Resource componentType = graph.getSingleType(doc);
                    Resource root = graph.syncRequest(new IndexRoot(doc));
                    return Pair.make(componentType, root);
                } else {
                    Resource root = graph.syncRequest(new IndexRoot(component));
                    return Pair.make(null, root);
                }
            }
            // TODO: For Antti to consider and fix later
            // Introduced to handle procedural user components where component == null
        } else if (literal != null) {
            Resource root = graph.syncRequest(new IndexRoot(literal));
            return Pair.make(null, root);
        } else {
            throw new DatabaseException("Couldn't resolve component type and root for component == null && literal == null");
        }
    }

}
