/*******************************************************************************
 * Copyright (c) 2019, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server.request;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.base.ontology.DocumentationResource;

class NodesRequest2 extends VariableRead<Set<Variable>> {

	public NodesRequest2(Variable var) {
		super(var);
	}

	@Override
	public Set<Variable> perform(ReadGraph graph) throws DatabaseException {

		DocumentationResource DOC = DocumentationResource.getInstance(graph);

		Resource type = variable.getPossibleType(graph);
		if(type == null)
			return Collections.emptySet();

		if(!graph.isInheritedFrom(type, DOC.Components_Component))
			return Collections.emptySet();

		Boolean pathExists = variable.getPossiblePropertyValue(graph, DOC.Properties_pathExists, Bindings.BOOLEAN);
		if(pathExists != null && !pathExists)
			return Collections.emptySet();

		if(graph.isInheritedFrom(type, DOC.Components_PrimitiveComponent)) {
			return Collections.singleton(variable);
		} else {
			Collection<Variable> children = variable.getChildren(graph);
			var result = graph.syncRequest(new CollectNodesRequest2(children));
			return result;
		}

	}

}