/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.variable.StandardAssertedGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.structural2.variables.StandardProceduralChildVariable;

class StandardDocumentProperties implements DocumentProperties {

	@Override
	public Collection<String> getKeys(ReadGraph graph, Variable parent) throws DatabaseException {

		if(parent instanceof StandardProceduralChildVariable) {

			StandardProceduralChildVariable procedural = (StandardProceduralChildVariable)parent;
			List<String> result = new ArrayList<>();
			for(Variable property : procedural.getProperties(graph)) {
				if(property instanceof StandardAssertedGraphPropertyVariable) {
					StandardAssertedGraphPropertyVariable ass = (StandardAssertedGraphPropertyVariable)property;
					if("dataDefinitions".equals(ass.property.name) || "pollingFunction".equals(ass.property.name)) {
						result.add(ass.property.name);
						continue;
					}
				}
				Resource predicate = property.getPossiblePredicateResource(graph);
				if(predicate != null) {
					PropertyInfo info = graph.syncRequest(new PropertyInfoRequest(predicate));
					if(info.hasClassification(DocumentationResource.URIs.Document_AttributeRelation)) {
						result.add(info.name);
					}
				}
			}

			return result;

		} else {

			Resource parentRes = parent.getRepresents(graph);
			return graph.syncRequest(new DocumentPropertyKeys(parentRes), TransientCacheAsyncListener.instance());

		}

	}

	@Override
	public Object getValue(ReadGraph graph, Variable context, String key) throws DatabaseException {
		return context.getPropertyValue(graph, key);
	}

}