/*******************************************************************************
 * Copyright (c) 2007, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.server;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.Functions.ParentExistsRequest;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;

public class PathExistsRequest extends VariableRead<Boolean> {

	public PathExistsRequest(Variable variable) {
		super(variable);
	}

	@Override
	public Boolean perform(ReadGraph graph) throws DatabaseException {

		Variable widget = variable.getParent(graph);

		Boolean exists = widget.getPossiblePropertyValue(graph, "exists");
		if (exists == null || !exists)
			return false;

		if (!graph.syncRequest(new ParentExistsRequest(widget.getParent(graph))))
			return false;

		Resource type = widget.getType(graph);
		Collection<String> pars = graph.syncRequest(new ParentRelationsRequest(type), TransientCacheAsyncListener.instance());

		int nCps = 0;
		for(String par : pars) {
			Connection conn = widget.getPossiblePropertyValue(graph, par);
			if(conn == null)
				continue;
			nCps++;
			Variable otherCp = DocumentServerUtils.getPossibleChildConnectionPointFromClassifications(graph, widget, conn);
			if (otherCp != null) {
				Variable parentWidget = otherCp.getParent(graph);
				if (parentWidget.<Boolean>getPropertyValue(graph, "pathExists")) {
					return true;
				}
			} else {
				Variable parentCp = graph.sync(new BinaryRead<Variable, Connection, Variable>(widget, conn) {
					@Override
					public Variable perform(ReadGraph graph) throws DatabaseException {
						DocumentationResource DOC = DocumentationResource.getInstance(graph);
						Collection<VariableConnectionPointDescriptor> descs = parameter2.getConnection2().getConnectionPointDescriptors(graph, parameter, null);
						for(VariableConnectionPointDescriptor desc : descs) {
							if (DOC.Relations_partN.equals(desc.getConnectionPointResource(graph))) {
								return desc.getVariable(graph);
							}
						}
						return null;
					}
				});
				if (parentCp != null) {
					Variable parentWidget = parentCp.getParent(graph);
					if (parentWidget.<Boolean>getPropertyValue(graph, "pathExists")) {
						return true;
					}
				}
			}
		}

		DocumentationResource DOC = DocumentationResource.getInstance(graph);
		return graph.isInheritedFrom(type, DOC.Components_ParentlessComponent) ||
				(graph.isInheritedFrom(type, DOC.DocumentComponent) && nCps == 0);

	}
}