/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommandMetadata;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.delta.RouteGraphDelta;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.RouteGraphModification;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphChangeEvent;
import org.simantics.scl.commands.Commands;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;

public class RouteGraphConnection {
    private static final boolean DEBUG_SYNC = false;
    private static final boolean USE_COMMAND_BASED_SYNCHRONIZATION = true;
    private Layer0 L0;
    private DiagramResource DIA;
    private ConnectionUtil cu;
    private Resource connection;
    private static Function ConnectionPoint;
    private static Function Element;
    private static Function RouteGraphStructure;
    private static Function UpdateLine;
    private static Function RemoveNode;
    private static Function RemoveLink;
    private static Function CreateLine;
    private static Function CreateLink;
    private static boolean initialized;

    static {
        initialized = false;
    }

    public static Write synchronizer(final Resource connection, final RouteGraphChangeEvent event) {
        return new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                RouteGraphConnection rgc = new RouteGraphConnection(graph, connection);
                rgc.synchronize(graph, event.before, event.after, event.delta);
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Modified connection route"));
                graph.markUndoPoint();
            }
        };
    }

    public RouteGraphConnection(WriteGraph graph, Resource connection) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.cu = new ConnectionUtil(graph);
        this.connection = connection;
    }

    private static void initialize(ReadGraph graph) {
        if (!initialized) {
            Object oldGraph = SCLContext.getCurrent().put((Object)"graph", (Object)graph);
            try {
                try {
                    ConnectionPoint = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/ConnectionPoint");
                    Element = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/Element");
                    RouteGraphStructure = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/RouteGraphStructure");
                    UpdateLine = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/UpdateLine");
                    RemoveNode = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/RemoveNode");
                    RemoveLink = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/RemoveLink");
                    CreateLine = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/CreateLine");
                    CreateLink = (Function)SCLOsgi.MODULE_REPOSITORY.getValue("Simantics/RouteGraph/CreateLink");
                    initialized = true;
                }
                catch (ValueNotFound e) {
                    e.printStackTrace();
                    SCLContext.getCurrent().put((Object)"graph", oldGraph);
                }
            }
            finally {
                SCLContext.getCurrent().put((Object)"graph", oldGraph);
            }
        }
    }

    private static Object getConnectorIdentifier(ReadGraph graph, Resource connector) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Statement stat : graph.getStatements(connector, STR.Connects)) {
            Resource pred = stat.getPredicate();
            Resource element = stat.getObject();
            if (graph.isSubrelationOf(pred, DIA.IsConnectorOf)) continue;
            Resource component = graph.getPossibleObject(element, MOD.ElementToComponent);
            if (component != null) {
                String componentName = (String)graph.getRelatedValue(component, L0.HasName);
                String relationName = (String)graph.getRelatedValue(graph.getInverse(pred), L0.HasName);
                return ConnectionPoint.apply((Object)componentName, (Object)relationName);
            }
            String elementName = (String)graph.getRelatedValue(element, L0.HasName);
            return Element.apply((Object)elementName);
        }
        throw new DatabaseException("Didn't find indentification for " + String.valueOf(connector) + ".");
    }

    public void synchronize(WriteGraph graph, RouteGraph before, RouteGraph after, RouteGraphDelta delta) throws DatabaseException {
        ArrayList<Integer> routeLinks;
        RouteGraphConnection.initialize((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource diagram = graph.getSingleObject(this.connection, L0.PartOf);
        Resource composite = graph.getSingleObject(diagram, MOD.DiagramToComposite);
        TObjectIntHashMap<RouteNode> routeNodeMap = new TObjectIntHashMap<RouteNode>(){

            protected int hash(Object notnull) {
                RouteNode node = (RouteNode)notnull;
                Object data = node.getData();
                if (data != null) {
                    return data.hashCode();
                }
                return node.hashCode();
            }

            protected boolean equals(Object notnull, Object two) {
                RouteNode node1 = (RouteNode)notnull;
                RouteNode node2 = (RouteNode)two;
                Object data1 = node1.getData();
                if (data1 == null) {
                    return node1 == node2;
                }
                Object data2 = node2.getData();
                return data1.equals(data2);
            }
        };
        ArrayList<Object> connectorIdentifiers = new ArrayList<Object>();
        for (RouteTerminal terminal : before.getTerminals()) {
            Resource connector = RouteGraphConnection.deserialize((ServiceLocator)graph, terminal.getData());
            connectorIdentifiers.add(RouteGraphConnection.getConnectorIdentifier((ReadGraph)graph, connector));
            routeNodeMap.put((Object)terminal, routeNodeMap.size());
        }
        if (before.isSimpleConnection()) {
            routeLinks = new ArrayList<Integer>(2);
            routeLinks.add(0);
            routeLinks.add(1);
        } else {
            THashSet linkSet = new THashSet();
            for (RouteLine line : before.getLines()) {
                int id = routeNodeMap.size();
                routeNodeMap.put((Object)line, id);
                for (RoutePoint rp : line.getPoints()) {
                    RouteLink link;
                    if (!(rp instanceof RouteLink) || (link = (RouteLink)rp).getA().isTransient() || link.getB().isTransient()) continue;
                    linkSet.add((Object)link);
                }
            }
            routeLinks = new ArrayList(linkSet.size() * 2 + before.getTerminals().size());
            for (RouteTerminal terminal : before.getTerminals()) {
                routeLinks.add(routeNodeMap.get((Object)terminal));
                routeLinks.add(routeNodeMap.get((Object)terminal.getLine()));
            }
            for (Object link : linkSet) {
                routeLinks.add(routeNodeMap.get((Object)link.getA()));
                routeLinks.add(routeNodeMap.get((Object)link.getB()));
            }
        }
        Object structure = RouteGraphStructure.apply((Object)composite, connectorIdentifiers, (Object)(routeNodeMap.size() - connectorIdentifiers.size()), routeLinks);
        ArrayList<Object> modifications = new ArrayList<Object>();
        ArrayList<Pair> newRouteLines = new ArrayList<Pair>();
        for (RouteGraphDelta.RouteLinePair pair : delta.getLinesThatDiffer()) {
            modifications.add(UpdateLine.apply((Object)routeNodeMap.get((Object)pair.left), (Object)pair.right.getPosition(), (Object)pair.right.isHorizontal()));
        }
        for (RouteLine added : delta.getLinesOnlyInRight()) {
            modifications.add(CreateLine.apply((Object)added.getPosition(), (Object)added.isHorizontal()));
            newRouteLines.add(Pair.make((Object)added, (Object)routeNodeMap.size()));
            routeNodeMap.put((Object)added, routeNodeMap.size());
        }
        for (RouteLink removed : delta.getLinksOnlyInLeft()) {
            modifications.add(RemoveLink.apply((Object)routeNodeMap.get((Object)removed.getA()), (Object)routeNodeMap.get((Object)removed.getB())));
        }
        for (RouteLine added : delta.getLinksOnlyInRight()) {
            modifications.add(CreateLink.apply((Object)routeNodeMap.get((Object)added.getA()), (Object)routeNodeMap.get((Object)added.getB())));
        }
        if (before.isSimpleConnection()) {
            if (!after.isSimpleConnection()) {
                modifications.add(RemoveLink.apply((Object)0, (Object)1));
                for (RouteTerminal terminal : after.getTerminals()) {
                    modifications.add(CreateLink.apply((Object)routeNodeMap.get((Object)terminal), (Object)routeNodeMap.get((Object)terminal.getLine())));
                }
            }
        } else if (after.isSimpleConnection()) {
            for (RouteTerminal terminal : before.getTerminals()) {
                modifications.add(RemoveLink.apply((Object)routeNodeMap.get((Object)terminal), (Object)routeNodeMap.get((Object)terminal.getLine())));
            }
            modifications.add(CreateLink.apply((Object)0, (Object)1));
        } else {
            for (RouteGraphDelta.RouteLinePair pair : delta.getTerminalsThatDiffer()) {
                int rightLine;
                int terminalId = routeNodeMap.get((Object)pair.left);
                int leftLine = routeNodeMap.get((Object)pair.left.getLine());
                if (leftLine == (rightLine = routeNodeMap.get((Object)pair.right.getLine()))) continue;
                modifications.add(RemoveLink.apply((Object)terminalId, (Object)leftLine));
                modifications.add(CreateLink.apply((Object)terminalId, (Object)rightLine));
            }
        }
        for (RouteTerminal removedTerminal : delta.getTerminalsOnlyInLeft()) {
            modifications.add(RemoveNode.apply((Object)routeNodeMap.get((Object)removedTerminal)));
        }
        for (RouteLink removed : delta.getLinesOnlyInLeft()) {
            modifications.add(RemoveNode.apply((Object)routeNodeMap.get((Object)removed)));
        }
        if (!modifications.isEmpty()) {
            List allRouteNodes = (List)Commands.get((ReadGraph)graph, (String)"Simantics/RouteGraph/modifyRouteGraph").execute((RequestProcessor)graph, (Resource)graph.syncRequest((Read)new IndexRoot(this.connection)), new Object[]{structure, modifications});
            for (Pair pair : newRouteLines) {
                ((RouteLine)pair.first).setData((Object)((Resource)allRouteNodes.get((Integer)pair.second)).getResourceId());
            }
        }
    }

    private void writeCommandMetadata(WriteGraph graph, RouteGraph left, RouteGraphDelta delta, RouteGraph right) {
        try {
            Object data;
            if (!delta.getTerminalsOnlyInLeft().isEmpty() || !delta.getTerminalsOnlyInRight().isEmpty()) {
                return;
            }
            RouteGraphModification proxy = new RouteGraphModification((SerialisationSupport)graph.getService(SerialisationSupport.class), left);
            TObjectIntHashMap<RouteNode> idMap = proxy.getIdMap();
            TObjectIntHashMap rightIdMap = new TObjectIntHashMap();
            final TObjectIntHashMap keyToId = new TObjectIntHashMap();
            idMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<RouteNode>(){

                public boolean execute(RouteNode a, int b) {
                    Object data = a.getData();
                    if (data != null) {
                        keyToId.put(data, b);
                    }
                    return true;
                }
            });
            for (RouteLine line : right.getLines()) {
                data = line.getData();
                if (!keyToId.containsKey(data)) continue;
                rightIdMap.put((Object)line, keyToId.get(data));
            }
            for (RouteTerminal terminal : right.getTerminals()) {
                data = terminal.getData();
                if (!keyToId.containsKey(data)) continue;
                rightIdMap.put((Object)terminal, keyToId.get(data));
            }
            int id = idMap.size();
            for (RouteLink link : delta.getLinksOnlyInLeft()) {
                proxy.addModi(new RouteGraphModification.RemoveLink(idMap.get((Object)link.getA()), idMap.get((Object)link.getB())));
            }
            for (RouteLine line : delta.getLinesOnlyInLeft()) {
                proxy.addModi(new RouteGraphModification.RemoveLine(idMap.get((Object)line)));
            }
            for (RouteGraphDelta.RouteLinePair pair : delta.getLinesThatDiffer()) {
                proxy.addModi(new RouteGraphModification.UpdateLine(idMap.get((Object)pair.left), pair.right.getPosition(), pair.right.isHorizontal()));
            }
            for (RouteLine line : delta.getLinesOnlyInRight()) {
                rightIdMap.put((Object)line, id++);
                proxy.addModi(new RouteGraphModification.CreateLine(line.getPosition(), line.isHorizontal()));
            }
            if (left.isSimpleConnection() && !right.isSimpleConnection()) {
                proxy.addModi(new RouteGraphModification.RemoveLink(0, 1));
            }
            for (RouteGraphDelta.RouteLinePair pair : delta.getTerminalsThatDiffer()) {
                if (pair.left.getLine() == pair.right.getLine()) continue;
                if (pair.left.getLine() != null) {
                    proxy.addModi(new RouteGraphModification.RemoveLink(idMap.get((Object)pair.left), idMap.get((Object)pair.left.getLine())));
                }
                if (pair.right.getLine() == null) continue;
                proxy.addModi(new RouteGraphModification.CreateLink(idMap.get((Object)pair.left), rightIdMap.get((Object)pair.right.getLine())));
            }
            if (!left.isSimpleConnection() && right.isSimpleConnection() && right.getTerminals().size() == 2) {
                Iterator it = right.getTerminals().iterator();
                proxy.addModi(new RouteGraphModification.CreateLink(rightIdMap.get(it.next()), rightIdMap.get(it.next())));
            }
            for (RouteLink link : delta.getLinksOnlyInRight()) {
                proxy.addModi(new RouteGraphModification.CreateLink(rightIdMap.get((Object)link.getA()), rightIdMap.get((Object)link.getB())));
            }
            Resource model = proxy.findTerminalIdentifiers((ReadGraph)graph);
            StringBuilder b = new StringBuilder();
            b.append("modifyConnection \"");
            proxy.toString(b);
            b.append("\"");
            if (model != null) {
                CommandMetadata.add((WriteGraph)graph, (long)model.getResourceId(), (String)b.toString());
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public Resource writeLine(WriteGraph graph, Resource line, RouteLine routeLine) throws DatabaseException {
        if (line == null) {
            line = graph.newResource();
            graph.claim(line, this.L0.InstanceOf, null, this.DIA.RouteLine);
            graph.claim(this.connection, this.DIA.HasInteriorRouteNode, line);
        }
        graph.claimLiteral(line, this.DIA.IsHorizontal, (Object)routeLine.isHorizontal());
        graph.claimLiteral(line, this.DIA.HasPosition, (Object)routeLine.getPosition());
        routeLine.setData(RouteGraphConnection.serialize((ServiceLocator)graph, line));
        return line;
    }

    public static Object serialize(ServiceLocator locator, Resource r) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)locator.getService(SerialisationSupport.class);
        return ss.getRandomAccessId(r);
    }

    public static Resource deserialize(ServiceLocator locator, Object o) throws DatabaseException {
        Resource r = RouteGraphConnection.tryDeserialize(locator, o);
        if (r != null) {
            return r;
        }
        throw new IllegalArgumentException("unrecognized object: " + String.valueOf(o));
    }

    public static Resource tryDeserialize(ServiceLocator locator, Object o) throws DatabaseException {
        if (o instanceof Long) {
            return ((SerialisationSupport)locator.getService(SerialisationSupport.class)).getResource(((Long)o).longValue());
        }
        return null;
    }
}

