/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.diagram.profile.ProfileKeys;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Style;

public class StyleBaseData {
    private static StyleBaseData INSTANCE;
    private final Map<Style, List<Resource>> removals = new HashMap<Style, List<Resource>>();

    private StyleBaseData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StyleBaseData getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<StyleBaseData> clazz = StyleBaseData.class;
        synchronized (StyleBaseData.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new StyleBaseData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public synchronized void removeItem(Style s, Resource r) {
        List<Resource> l = this.removals.get(s);
        if (l == null) {
            l = new ArrayList<Resource>();
            this.removals.put(s, l);
        }
        l.add(r);
    }

    public synchronized void applyRemovals(EvaluationContext evaluationContext, StyleBase<?> s) {
        List<Resource> rs = this.removals.remove(s);
        if (rs == null) {
            return;
        }
        DataNodeMap map = (DataNodeMap)evaluationContext.getConstant(ProfileKeys.NODE_MAP);
        for (Resource item : rs) {
            s.cleanupStyleForItem(evaluationContext, map, item);
        }
    }
}

