/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.awt.Point;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.common.request.UnaryAsyncRead;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.ElementFactoryAdapter;
import org.simantics.diagram.adapter.ElementFactoryUtil;
import org.simantics.diagram.elements.SVGImage;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.RequireImageFocusMode;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.ImageClass;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.ProviderUtils;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;

public class SVGElementClassFactory
extends ElementFactoryAdapter {
    public static final ElementFactory INSTANCE = new SVGElementClassFactory();
    private static final StaticSymbolImpl STATIC_SYMBOL = new StaticSymbolImpl((Image)DefaultImages.SVG.get());

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, final AsyncProcedure<ElementClass> procedure) {
        graph.asyncRequest((AsyncRead)new ClassRequest(elementType), (AsyncListener)new TransientCacheAsyncListener<ElementClass>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            public void execute(AsyncReadGraph graph, ElementClass result) {
                procedure.execute(graph, (Object)result);
            }
        });
    }

    static void createClass(AsyncReadGraph graph, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        String id = "SVGElement: " + elementType.getResourceId();
        procedure.execute(graph, (Object)ElementClass.compile((ElementHandler[])new ElementHandler[]{TextImpl.INSTANCE, new StaticObjectAdapter((Object)elementType), DefaultTransform.INSTANCE, StaticSymbolImageInitializer.INSTANCE, STATIC_SYMBOL, ImageClass.ImageElementHandler.INSTANCE, SimpleElementLayers.INSTANCE, RequireImageFocusMode.INSTANCE}).setId(id));
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e, AsyncProcedure<IElement> procedure) {
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)TransformSynchronizer.INSTANCE);
        GuardedAsyncProcedureWrapper guard = new GuardedAsyncProcedureWrapper(procedure, 3);
        this.loadSVG(graph, diagram, element, e, (AsyncProcedure<IElement>)guard);
        ElementFactoryUtil.loadLayersForElement(graph, diagram, e, element, (AsyncProcedure<IElement>)guard);
        ElementFactoryUtil.readTransform(graph, element, e, (AsyncProcedure<IElement>)guard);
    }

    private void loadSVG(AsyncReadGraph graph, final IDiagram diagram, final Resource element, final IElement e, final AsyncProcedure<IElement> guard) {
        G2DResource G2D = (G2DResource)graph.getService(G2DResource.class);
        graph.forPossibleRelatedValue(element, G2D.HasSVGDocument, (Binding)Bindings.STRING, (AsyncProcedure)new AsyncProcedure<String>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                guard.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, String svgDocument) {
                if (svgDocument != null) {
                    Point referenceSize = (Point)diagram.getHint(DiagramHints.KEY_ELEMENT_RASTER_TARGET_SIZE);
                    IFactory img = SVGImage.createFactoryFromString(String.valueOf(element.getResourceId()), svgDocument, referenceSize);
                    try {
                        img = ProviderUtils.rasterize(img);
                        e.setHint(ElementHints.KEY_IMAGE, img.get());
                        guard.execute(graph, (Object)e);
                    }
                    catch (ProvisionException ex) {
                        ErrorLogger.defaultLogError((Throwable)ex);
                        e.setHint(ElementHints.KEY_IMAGE, DefaultImages.SVG.get());
                        guard.execute(graph, (Object)e);
                    }
                } else {
                    e.setHint(ElementHints.KEY_IMAGE, DefaultImages.UNKNOWN.get());
                    guard.execute(graph, (Object)e);
                }
            }
        });
    }

    static class ClassRequest
    extends UnaryAsyncRead<Resource, ElementClass> {
        public ClassRequest(Resource elementType) {
            super((Object)elementType);
        }

        public void perform(AsyncReadGraph graph, AsyncProcedure<ElementClass> procedure) {
            SVGElementClassFactory.createClass(graph, (Resource)this.parameter, procedure);
        }
    }
}

