/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.structural.stubs.StructuralResource2;

public class ExpressionStyle
extends StyleBase<Map<String, Object>> {
    final Resource style;

    public ExpressionStyle(Resource style) {
        this.style = style;
    }

    @Override
    public Map<String, Object> calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable activeVariable) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        StructuralResource2 SR = StructuralResource2.getInstance((ReadGraph)graph);
        String key = (String)graph.getPossibleRelatedValue(this.style, DIA.HasVariableName, (Binding)Bindings.STRING);
        String expression = (String)graph.getPossibleRelatedValue(this.style, L0X.HasExpression, (Binding)Bindings.STRING);
        Resource module = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (module == null) {
            return null;
        }
        Resource svg = null;
        Resource elementType = graph.getPossibleType(element, L0.Entity);
        if (elementType == null) {
            return null;
        }
        Resource definition = graph.getPossibleObject(elementType, SR.IsDefinedBy);
        if (definition == null) {
            return null;
        }
        List items = OrderedSetUtils.toList((ReadGraph)graph, (Resource)definition);
        if (items == null) {
            return null;
        }
        for (Resource item : items) {
            if (!graph.isInstanceOf(item, DIA.AnimatedSVGElement)) continue;
            svg = item;
            break;
        }
        if (svg == null) {
            return null;
        }
        String moduleName = (String)graph.getPossibleRelatedValue(module, L0.HasName, (Binding)Bindings.STRING);
        if (moduleName == null) {
            return null;
        }
        Variable moduleVariable = activeVariable.getChild(graph, moduleName);
        Object value = moduleVariable.getPossiblePropertyValue(graph, expression);
        Map<String, Object> values = Collections.singletonMap(key, value);
        return values;
    }

    @Override
    public void applyStyleForNode(EvaluationContext evaluationContext, INode node, Map<String, Object> values) {
        if (values == null) {
            return;
        }
        ProfileVariables.claimNodeProperty((INode)node, (String)"valuezz", values, (EvaluationContext)evaluationContext);
    }

    @Override
    protected void cleanupStyleForNode(EvaluationContext observer, INode node) {
        ProfileVariables.init((INode)node, (Observer)observer);
    }

    public String toString() {
        return "Expression";
    }
}

