/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.diagram.adapter.BaseRequest2;
import org.simantics.diagram.adapter.ConnectionInfo;
import org.simantics.diagram.adapter.ConnectionInfoRequest;
import org.simantics.diagram.adapter.ConnectionSegmentAdapter;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.adapter.SpawnEdgeRequest;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.impl.Element;

public class EdgeRequest
extends BaseRequest2<EdgeResource, IElement> {
    final GraphToDiagramSynchronizer synchronizer;
    final ErrorHandler errorHandler;
    final ListenerSupport listenerSupport;
    final IDiagram diagram;
    final ConnectionSegmentAdapter adapter;

    public EdgeRequest(GraphToDiagramSynchronizer synchronizer, ICanvasContext canvas, ErrorHandler errorHandler, ListenerSupport listenerSupport, IDiagram diagram, ConnectionSegmentAdapter adapter, EdgeResource resource) {
        super(canvas, resource);
        assert (adapter != null);
        assert (synchronizer != null);
        this.synchronizer = synchronizer;
        this.errorHandler = errorHandler;
        this.listenerSupport = listenerSupport;
        this.diagram = diagram;
        this.adapter = adapter;
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<IElement> procedure) {
        final DiagramResource dr = (DiagramResource)graph.getService(DiagramResource.class);
        graph.forHasStatement(((EdgeResource)this.data).first(), (AsyncProcedure)new AsyncProcedure<Boolean>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, Boolean result) {
                if (!result.booleanValue()) {
                    procedure.execute(graph, null);
                    return;
                }
                graph.asyncRequest((AsyncRead)new ConnectionInfoRequest(dr, (EdgeResource)EdgeRequest.this.data), (AsyncListener)new TransientCacheAsyncListener<ConnectionInfo>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).EdgeRequest.this.errorHandler.error("ConnectionInfoRequest failure", throwable);
                    }

                    public void execute(AsyncReadGraph graph, final ConnectionInfo info) {
                        (this).EdgeRequest.this.adapter.getClass(graph, (EdgeResource)(this).EdgeRequest.this.data, info, (this).EdgeRequest.this.listenerSupport, (this).EdgeRequest.this.canvas, (this).EdgeRequest.this.diagram, new AsyncProcedure<ElementClass>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                ((this).this).EdgeRequest.this.errorHandler.error("ConnectionSegmentAdapter(" + String.valueOf(((this).this).EdgeRequest.this.adapter) + ").getClass failure", throwable);
                            }

                            public void execute(AsyncReadGraph graph, final ElementClass clazz) {
                                if (clazz == null) {
                                    procedure.execute(graph, null);
                                    return;
                                }
                                graph.asyncRequest((AsyncRead)new SpawnEdgeRequest(((this).this).EdgeRequest.this.canvas, clazz, (EdgeResource)((this).this).EdgeRequest.this.data), (AsyncProcedure)new AsyncProcedure<IElement>(){

                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                        (((this).this).this).EdgeRequest.this.errorHandler.error("SpawnEdgeRequest failure", throwable);
                                    }

                                    public void execute(AsyncReadGraph graph, IElement element) {
                                        if (DebugPolicy.DEBUG_EDGE_LOAD) {
                                            System.out.println("    SPAWNED EDGE SEGMENT: " + String.valueOf(element) + " " + String.valueOf((((this).this).this).EdgeRequest.this.data));
                                        }
                                        (((this).this).this).EdgeRequest.this.synchronizer.mapElementIfNew((((this).this).this).EdgeRequest.this.data, element);
                                        procedure.execute(graph, (Object)element);
                                        IElement loadingElement = Element.spawnNew((ElementClass)clazz);
                                        loadingElement.setHint(ElementHints.KEY_OBJECT, (((this).this).this).EdgeRequest.this.data);
                                        (((this).this).this).EdgeRequest.this.adapter.load(graph, (EdgeResource)(((this).this).this).EdgeRequest.this.data, info, (((this).this).this).EdgeRequest.this.listenerSupport, (((this).this).this).EdgeRequest.this.canvas, (((this).this).this).EdgeRequest.this.diagram, loadingElement);
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }
}

