/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.util.Collection;
import java.util.Iterator;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;

/**
 * @author Tuukka Lehtonen
 */
public class RemoveBranchpoint extends ModificationAdapter {

    Resource element;

    public RemoveBranchpoint(IElement element) {
        super(REMOVE_BRANCH_PRIORITY);
        this.element = element.getHint(ElementHints.KEY_OBJECT);
        assert element != null;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance(g);
        Collection<Resource> connectors = g.getObjects(element, dr.AreConnected);

        ConnectionUtil cu = new ConnectionUtil(g);
        cu.removeConnectionPart(element);

        // If this *was* a route point, reconnect the connectors previously
        // connected to the route point. Otherwise just leave it.
        if (connectors.size() == 2) {
            Iterator<Resource> it = connectors.iterator();
            Resource c1 = it.next();
            Resource c2 = it.next();
            cu.connect(c1, c2);
        }
    }

}
