/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * @author Tuukka Lehtonen
 */
public class FlagSynchronizer extends ResourceSynchronizer {

    public static final FlagSynchronizer INSTANCE = new FlagSynchronizer();

    protected static final Key[] SYNCHRONIZED_HINTS = {
        FlagClass.KEY_FLAG_TYPE,
    };

    @Override
    public Key[] getSynchronizedHints() {
        return SYNCHRONIZED_HINTS;
    }

    @Override
    public boolean hintChanged(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable sender, Key key, Object oldValue, Object newValue) {
        BasicResources br = context.get(GraphSynchronizationHints.BASIC_RESOURCES);
        if (FlagClass.KEY_FLAG_TYPE.equals(key)) {
            FlagClass.Type type = (FlagClass.Type) newValue;
            return queue.offer(new EnumerationModification(object, br.DIA.HasFlagType, DiagramGraphUtil.toFlagTypeResource(br.DIA, type)));
        }

        return super.hintChanged(context, sender, key, oldValue, newValue);
    }

}
