/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import org.simantics.diagram.synchronization.graph.CopyAdvisorUtil;

/**
 * @author Tuukka Lehtonen
 * @see CopyAdvisor
 * @see CopyAdvisorUtil#copy2(org.simantics.db.WriteGraph, org.simantics.db.Resource, org.simantics.utils.datastructures.BinaryFunction)
 */
public enum StatementEvaluation {
    /**
     * Use default copying logic for the statement, depending on the type of
     * the relation.
     */
    USE_DEFAULT,
    /**
     * Do not include the evaluated statement in the copy.
     */
    SKIP,
    /**
     * Include this statement for the copy but do not follow it.
     */
    INCLUDE,
    /**
     * Include this statement for the copy and follow it to continue copying
     * recursively from the object.
     */
    INCLUDE_AND_FOLLOW
}