/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary.ui;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Tuukka Lehtonen
 */
class FilterConfiguration {

    public enum Mode {
        AND, OR
    };

    Mode              mode;
    List<GroupFilter> filters = new ArrayList<GroupFilter>();

    public FilterConfiguration() {
        this.mode = Mode.OR;
        this.filters = new ArrayList<GroupFilter>();
    }

    public FilterConfiguration(List<GroupFilter> filters) {
        this.mode = Mode.OR;
        this.filters = filters;
    }

    public FilterConfiguration(FilterConfiguration orig) {
        this.mode = orig.mode;
        this.filters = new ArrayList<GroupFilter>(orig.filters);
    }

    List<GroupFilter> getFilters() {
        return filters;
    }

    void setMode(Mode mode) {
        this.mode = mode;
    }

    Mode getMode() {
        return mode;
    }

}
