/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - GitLab #1070
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * @author Tuukka Lehtonen
 */
public class EmptySymbolProviderFactory implements SymbolProviderFactory {

    public static final EmptySymbolProviderFactory INSTANCE = new EmptySymbolProviderFactory();

    SymbolProvider PROVIDER = new SymbolProvider();

    @Override
    public ISymbolProvider create(ReadGraph g) throws DatabaseException {
        return PROVIDER;
    }

}
