/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.runtime;

import org.simantics.utils.datastructures.map.Tuple;

/**
 * @author Tuukka Lehtonen
 */
public class RuntimeDiagramDesc extends Tuple {

    public RuntimeDiagramDesc(String modelURI, String variableURI, String rvi, String activeProfileURI) {
        super(modelURI, variableURI, rvi, activeProfileURI);
    }

    public String getModelURI() {
        return (String) getField(0);
    }

    public String getVariableURI() {
        return (String) getField(1);
    }

    public String getRVI() {
        return (String) getField(2);
    }

    public String getActiveProfileURI() {
        return (String) getField(3);
    }

}