/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import gnu.trove.map.hash.THashMap;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.template2d.ontology.Template2dResource;

/**
 * @author Tuukka Lehtonen
 */
public class FlagTables extends ResourceRead<Map<String, Resource>> {

    public FlagTables(Resource drawingTemplate) {
        super(drawingTemplate);
    }

    @Override
    public Map<String, Resource> perform(ReadGraph graph) throws DatabaseException {
        Map<String, Resource> childMap = graph.syncRequest(new UnescapedChildMapOfResource(resource));
        if (childMap.isEmpty())
            return childMap;

        Template2dResource TEMPLATE2D = Template2dResource.getInstance(graph);
        Map<String, Resource> flagTables = new THashMap<String, Resource>(childMap.size());
        for (Map.Entry<String, Resource> entry : childMap.entrySet()) {
            if (graph.isInstanceOf(entry.getValue(), TEMPLATE2D.FlagTable)) {
                flagTables.put(entry.getKey(), entry.getValue());
            }
        }

        return flagTables;
    }

}
