package org.simantics.diagram.profile;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.profile.ProfileActivityBean.Profile;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * @author Tuukka Lehtonen
 * @since 1.32.0
 */
class ProfileActivityBeanRequest extends ResourceRead<ProfileActivityBean> {

	public ProfileActivityBeanRequest(Resource root) {
		super(root);
	}

	@Override
	public ProfileActivityBean perform(ReadGraph graph) throws DatabaseException {
		ProfileActivityBean bean = new ProfileActivityBean();
		String rootUri = graph.getPossibleURI(resource);
		if (rootUri == null)
			return bean;

		for (NamedResource r : graph.syncRequest(new TopLevelProfiles(resource))) {
			Profile prof = readProfile(graph, rootUri, r.getResource());
			if (prof != null)
				bean.topLevelProfiles.put(prof.relativeUri, prof);
		}

		DiagramResource DIA = DiagramResource.getInstance(graph);
		Resource activeProfile = graph.getPossibleObject(resource, DIA.HasActiveProfile);
		if (activeProfile != null) {
			bean.activeProfile = Profiles.possiblyRelativeUri(graph, rootUri, activeProfile);
		}

		return bean;
	}

	private static Profile readProfile(ReadGraph graph, String rootUri, Resource profile) throws DatabaseException {
		Profile prof = new Profile();
		prof.relativeUri = Profiles.possiblyRelativeUri(graph, rootUri, profile);
		if (prof.relativeUri == null)
			return null;

		SimulationResource SIMU = SimulationResource.getInstance(graph);
		for (Resource active : graph.getObjects(profile, SIMU.IsActive)) {
			String euri = Profiles.possiblyRelativeUri(graph, rootUri, active);
			if (euri != null)
				prof.activeEntries.add(euri);
		}

		return prof;
	}

}
