/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.participant;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.List;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.utils.logging.TimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract public class PopulateSelectionDropParticipant extends AbstractDiagramParticipant implements IDropTargetParticipant {

	private static final Logger LOGGER = LoggerFactory.getLogger(PopulateSelectionDropParticipant.class);

	public abstract List<ElementClassDragItem> getElements(Session session, IStructuredSelection selection) throws DatabaseException;
	
	protected GraphToDiagramSynchronizer synchronizer;

	public PopulateSelectionDropParticipant(GraphToDiagramSynchronizer synchronizer) {
		this.synchronizer = synchronizer;
	}

	@Override
	public void dragEnter(DropTargetDragEvent dtde, final IDnDContext dp) {

		Transferable tr = dtde.getTransferable();

		if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {

			Session session = synchronizer.getSession();

			// System.out.println("joo");
			Object obj = null;

			// This must be done to have SWT transfer set the source data
			try {
				
				obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
				//System.out.println("GOT FROM AWT: " + obj);

				// Check SWT
				if (!(obj instanceof IStructuredSelection)) {
					obj = LocalObjectTransfer.getTransfer().getObject();
					//System.out.println("GOT FROM SWT: " + obj);
				}

				if (obj instanceof IStructuredSelection) {

					IStructuredSelection sel = (IStructuredSelection) obj;
					if (!sel.isEmpty()) {
						
						List<ElementClassDragItem> items = getElements(session, sel);

						for(ElementClassDragItem item : items) {
							dp.add(item);
						}

						dp.getHints().setHint(DnDHints.KEY_DND_GRID_COLUMNS, Integer.valueOf(1));

					}

				}

			} catch (DatabaseException | IOException | UnsupportedFlavorException e) {
				LOGGER.error("Unexpected failure", e);
			}

		}

		dtde.acceptDrag(DnDConstants.ACTION_COPY);

	}

	@Override
	public void drop(DropTargetDropEvent dtde, final IDnDContext dp) {
	    TimeLogger.resetTimeAndLog(getClass(), "drop");
	    
        final IDiagram d = getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null)
            return;

        DiagramUtils.mutateDiagram(d, m -> {
            IDragItem items[] = dp.toArray();

            for (IDragItem i : items) {
                if (!(i instanceof ElementClassDragItem))
                    continue;

                ElementClassDragItem res = (ElementClassDragItem) i;
                ElementClass ec = res.getElementClass();

                Point2D pos = dp.getItemPosition(i);
                // System.out.println(pos);
                assert (pos != null);

                IElement element = m.newElement(ec);
                element.setHints(res.getHintContext().getHints());

                ISnapAdvisor snapAdvisor = getContext().getHintStack().getHint(DiagramHints.SNAP_ADVISOR);
                if(snapAdvisor != null)
                    snapAdvisor.snap(pos);
                ElementUtils.setPos(element, pos);

                // Remove only the drag items we've processed.
                dp.remove(i);
            }
        });

        synchronizer.getCanvasContext().getContentContext().setDirty();
		
	}

	@Override
	public void dragOver(DropTargetDragEvent dtde, IDnDContext dp) {
	}
	
	@Override
	public void dragExit(DropTargetEvent dte, IDnDContext dp) {
	}
	
	@Override
	public void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp) {
	}

	@Override
	public int getAllowedOps() {
		return 0;
	}
	
    @Override
    public double getPriority() {
    	return 9.1;
    }
	
}