/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import java.util.function.Consumer;
import org.simantics.db.ClusterCreator;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.ServiceLocator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.SDBException;
import org.simantics.db.service.ClusterUID;

public interface Database {
    public DatabaseUserAgent getUserAgent();

    public void setUserAgent(DatabaseUserAgent var1);

    public Status getStatus();

    public File getFolder();

    public boolean isFolderOk();

    public boolean isFolderOk(File var1);

    public boolean isFolderEmpty();

    public boolean isFolderEmpty(File var1);

    public void initFolder(Properties var1) throws SDBException;

    public void deleteFiles() throws SDBException;

    public void start() throws SDBException;

    public boolean isRunning() throws SDBException;

    public boolean tryToStop() throws SDBException;

    public void connect() throws SDBException;

    public boolean isConnected() throws SDBException;

    public String execute(String var1) throws SDBException;

    public void disconnect() throws SDBException;

    public void clone(File var1, int var2, boolean var3) throws SDBException;

    public Path createFromChangeSets(int var1) throws SDBException;

    public void deleteGuard() throws SDBException;

    public Path dumpChangeSets() throws SDBException;

    public void purgeDatabase(Consumer<Collection<ClusterUID>> var1) throws SDBException;

    public long serverGetTailChangeSetId() throws SDBException;

    public Session newSession(ServiceLocator var1) throws SDBException;

    public Journal getJournal() throws SDBException;

    public String getCompression();

    public static interface Journal {
        public boolean canRead();

        public int count();

        public int read(int var1, Line var2) throws SDBException;

        public static class Line {
            public boolean status;
            public String request;
            public String comment;
        }
    }

    public static interface Session {
        public Database getDatabase();

        public void close() throws SDBException;

        public void open() throws SDBException;

        public boolean isClosed() throws SDBException;

        public void acceptCommit(long var1, long var3, byte[] var5) throws SDBException;

        public long cancelCommit(long var1, long var3, byte[] var5, OnChangeSetUpdate var6) throws SDBException;

        public Transaction askReadTransaction() throws SDBException;

        public Transaction askWriteTransaction(long var1) throws SDBException;

        public long endTransaction(long var1) throws SDBException;

        public String execute(String var1) throws SDBException;

        public byte[] getChangeSetMetadata(long var1) throws SDBException;

        public ChangeSetData getChangeSetData(long var1, long var3, OnChangeSetUpdate var5) throws SDBException;

        public ChangeSetIds getChangeSetIds() throws SDBException;

        public Cluster getCluster(byte[] var1) throws SDBException;

        public ClusterChanges getClusterChanges(long var1, byte[] var3) throws SDBException;

        public ClusterIds getClusterIds() throws SDBException;

        public Information getInformation() throws SDBException;

        public Refresh getRefresh(long var1) throws SDBException;

        public ResourceSegment getResourceSegment(byte[] var1, int var2, long var3, short var5) throws SDBException;

        public long reserveIds(int var1) throws SDBException;

        public void updateCluster(byte[] var1) throws SDBException;

        public boolean undo(long[] var1, OnChangeSetUpdate var2) throws SDBException;

        public <T> T clone(ClusterUID var1, ClusterCreator var2) throws DatabaseException;

        public boolean refreshEnabled();

        public boolean rolledback();

        public static interface ChangeSetData {
            public boolean isOk();
        }

        public static interface ChangeSetIds {
            public long getFirstChangeSetId();

            public int getCount();
        }

        public static interface ChangeSetUpdate {
            public long getChangeSetId();

            public int getChangeSetIndex();

            public int getNumberOfClusterChangeSets();

            public int getIndexOfClusterChangeSet();

            public byte[] getClusterId();

            public boolean getNewCluster();

            public byte[] getData();
        }

        public static interface Cluster {
            public int getInflateSize();

            public ByteBuffer getDeflated();
        }

        public static interface ClusterChanges {
            public long getHeadChangeSetId();

            public int[] getResourceIndex();

            public int[] getPredicateIndex();

            public long[] getPredicateFirst();

            public long[] getPredicateSecond();

            public int[] getValueIndex();
        }

        public static interface ClusterIds {
            public int getStatus();

            public long[] getFirst();

            public long[] getSecond();
        }

        public static interface Information {
            public String getServerId();

            public String getProtocolId();

            public String getDatabaseId();

            public long getFirstChangeSetId();
        }

        public static interface OnChangeSetUpdate {
            public void onChangeSetUpdate(ChangeSetUpdate var1) throws SDBException;
        }

        public static interface Refresh {
            public long getHeadChangeSetId();

            public long[] getFirst();

            public long[] getSecond();
        }

        public static interface ResourceSegment {
            public byte[] getClusterId();

            public int getResourceIndex();

            public long getValueSize();

            public byte[] getSegment();

            public long getOffset();
        }

        public static interface Transaction {
            public long getHeadChangeSetId();

            public long getTransactionId();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Status {
        NoDatabase{

            @Override
            public String getString() {
                return "NoDatabase";
            }
        }
        ,
        NotRunning{

            @Override
            public String getString() {
                return "NotRunning";
            }
        }
        ,
        Standalone{

            @Override
            public String getString() {
                return "Standalone";
            }
        }
        ,
        Local{

            @Override
            public String getString() {
                return "Local";
            }
        }
        ,
        Remote{

            @Override
            public String getString() {
                return "Remote";
            }
        };

        public String message = "";

        public abstract String getString();

        public String toString() {
            return this.message;
        }
    }
}

