/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.adaption;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncProcedure;

/**
 * @author Antti Villberg
 *
 * @param <T> the target interface constructed by this adapter
 * 
 * @see SimpleAdapter<T> Synchronous wrapper implementation
 */
public interface Adapter<T, Context> {
    void adapt(AsyncReadGraph g, Resource resource, Context context, AsyncProcedure<T> procedure);
}
