/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.IntAllocatorI;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableIntAllocatorAdapter;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ForeachObject;
import org.simantics.db.procore.cluster.ForeachPredicate;
import org.simantics.db.procore.cluster.IntHashTrait;
import org.simantics.db.procore.cluster.TableIntArraySet;
import org.simantics.db.procore.cluster.TableIntSet;

public class CompleteTable
extends Table<int[]> {
    private TIntHashSet checkIndexSet = null;

    public CompleteTable(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase);
    }

    public CompleteTable(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase, (Object)ints);
    }

    final int createCompleteArraySet(int o1, int o2) throws DatabaseException {
        if (o1 == 0 || o1 == o2) {
            throw new DatabaseException("Illegal argument to createObejctArray");
        }
        int[] obs = new int[]{o1, o2};
        int hashBase = TableIntArraySet.create(obs, (IntAllocatorI)new TableIntAllocatorAdapter((Table)this));
        return this.convertRealIndexToTableIndex(hashBase);
    }

    final void deleteCompleteSet(int index) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(index, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            int capacity = TableIntArraySet.getAllocatedSize((int[])this.getTable(), hashBase);
            int elementIndex = index - 1;
            this.deleteOldElement(elementIndex, capacity);
        } else {
            int capacity = TableIntSet.getAllocatedSize((int[])this.getTable(), hashBase);
            int elementIndex = index - 4;
            this.deleteOldElement(elementIndex, capacity);
        }
    }

    final int getCompleteSetSize(int objectIndex) {
        int hashBase = this.checkIndexAndGetRealIndex(objectIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            return TableIntArraySet.getSize((int[])this.getTable(), hashBase);
        }
        return TableIntSet.getSize((int[])this.getTable(), hashBase);
    }

    final int addComplete(int setIndex, int oResourceIndex) throws DatabaseException {
        int newHashBase;
        int hashBase = this.checkIndexAndGetRealIndex(setIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            if (TableIntArraySet.getSize((int[])this.getTable(), hashBase) < 5) {
                newHashBase = TableIntArraySet.addInt((int[])this.getTable(), hashBase, oResourceIndex, (IntAllocatorI)new TableIntAllocatorAdapter((Table)this));
            } else {
                TableIntArraySet.Ints ints = TableIntArraySet.getIntsIfValueNotFound((int[])this.getTable(), hashBase, oResourceIndex);
                if (ints.found) {
                    return 0;
                }
                this.deleteCompleteSet(setIndex);
                newHashBase = TableIntSet.create(ints.ints, (IntAllocatorI)new TableIntAllocatorAdapter((Table)this));
                assert (newHashBase != 0);
            }
        } else {
            newHashBase = TableIntSet.addInt((int[])this.getTable(), hashBase, oResourceIndex, (IntAllocatorI)new TableIntAllocatorAdapter((Table)this));
        }
        if (newHashBase == 0) {
            return 0;
        }
        int ni = this.convertRealIndexToTableIndex(newHashBase);
        return ni;
    }

    final int removeLast(int setIndex) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(setIndex, 0);
        int[] table = (int[])this.getTable();
        int ref = TableIntArraySet.isArraySet(table, hashBase) ? TableIntArraySet.removeIntLast(table, hashBase) : TableIntSet.removeIntLast(table, hashBase);
        this.deleteCompleteSet(setIndex);
        return ref;
    }

    final int removeComplete(int setIndex, int oResourceIndex) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(setIndex, 0);
        int[] table = (int[])this.getTable();
        if (TableIntArraySet.isArraySet(table, hashBase)) {
            return TableIntArraySet.removeInt(table, hashBase, oResourceIndex);
        }
        TableIntSet.removeInt(table, hashBase, oResourceIndex);
        return TableIntSet.getSize(table, hashBase);
    }

    public final <Context> boolean foreachComplete(int setIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(setIndex, 0);
        boolean ret = TableIntArraySet.isArraySet((int[])this.getTable(), hashBase) ? TableIntArraySet.foreachInt((int[])this.getTable(), hashBase, procedure, context, modifier) : TableIntSet.foreachInt((int[])this.getTable(), hashBase, procedure, context, modifier);
        return ret;
    }

    public <Context> boolean foreachPredicate(int setIndex, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        ForeachPredicate<Context> t = new ForeachPredicate<Context>(procedure, support, modifier);
        return this.foreachComplete(setIndex, t, context, null, null);
    }

    public <Context> boolean foreachObject(int setIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, ClusterI.CompleteTypeEnum completeType) throws DatabaseException {
        ForeachObject<Context> t = new ForeachObject<Context>(procedure, support, modifier, completeType);
        return this.foreachComplete(setIndex, t, context, null, null);
    }

    private void checkEntry(ClusterBase cluster, int[] table, int index) throws DatabaseException {
        ClusterI.CompleteTypeEnum type = ClusterTraits.completeReferenceGetType(table[index]);
        if (type == ClusterI.CompleteTypeEnum.NotComplete) {
            throw new ValidationException("Illegal CompleteTable entry type. Entry=" + table[index] + " index=" + index);
        }
        int fi = ClusterTraits.completeReferenceGetForeignIndex(table[index]);
        int ri = ClusterTraits.completeReferenceGetResourceIndex(table[index]);
        if (fi != 0) {
            cluster.checkForeingIndex(fi);
            if (ri < 1 || ri > ClusterTraits.getMaxNumberOfResources()) {
                throw new ValidationException("Illegal CompleteTable foreign entry. Entry=" + table[index] + " index=" + index);
            }
        }
    }

    public final void check(ClusterBase cluster) throws DatabaseException {
        if (this.checkIndexSet == null) {
            this.checkIndexSet = new TIntHashSet();
        } else {
            this.checkIndexSet.clear();
        }
        int count = 0;
        int[] table = (int[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int pe = ps + this.getTableSize();
        int p = ps;
        while (p < pe) {
            int cap;
            if (table[cap = p++] >= 0) {
                int use = p++;
                int fre = p++;
                int max = p++;
                assert (table[cap] >= table[use] + table[fre]);
                assert (table[max] == table[cap] >> 1);
                assert (table[max] + 1 >= table[use]);
                this.checkIndexSet.add(p - ps);
                int e = p + table[cap];
                while (p < e) {
                    if (IntHashTrait.isFull(table[p])) {
                        this.checkEntry(cluster, table, p);
                    }
                    ++p;
                }
            } else {
                int size = -table[cap];
                assert (size > 0);
                this.checkIndexSet.add(p - ps);
                boolean free = false;
                int e = p + size;
                while (p < e) {
                    if (free) {
                        assert (table[p] == 0);
                    } else if (table[p] == 0) {
                        free = true;
                    } else {
                        this.checkEntry(cluster, table, p);
                    }
                    ++p;
                }
            }
            ++count;
        }
        assert (this.getHeader().getCount() <= count);
    }

    public final void checkCompleteSetIndex(ClusterBase cluster, int i) throws DatabaseException {
        if (this.checkIndexSet == null) {
            this.check(cluster);
        }
        if (!this.checkIndexSet.contains(i - 1)) {
            throw new ValidationException("Illegal object set index=" + i);
        }
    }

    final void printDebugInfo() {
        int count = 0;
        int[] table = (int[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int pe = ps + this.getTableSize();
        TIntIntHashMap stat = new TIntIntHashMap();
        TIntIntHashMap stat2 = new TIntIntHashMap();
        int p = ps;
        while (p < pe) {
            int cap;
            if (table[cap = p++] >= 0) {
                int use = p++;
                int fre = p++;
                int max = p++;
                assert (table[cap] >= table[use] + table[fre]);
                assert (table[max] == table[cap] >> 1);
                p += table[cap];
                int val = stat.get(table[use]) + 1;
                stat.put(table[use], val);
            } else {
                int size = -table[cap];
                int val = stat2.get(size) + 1;
                stat2.put(size, val);
                p += size;
            }
            ++count;
        }
        assert (this.getHeader().getCount() == count);
        stat.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int a, int b) {
                System.out.println("complete set capacity " + a + " instance count " + b);
                return true;
            }
        });
        stat2.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int a, int b) {
                System.out.println("complete array set capacity " + a + " instance count " + b);
                return true;
            }
        });
    }

    public <Context> boolean foreach(int setIndex, ClusterI.Procedure procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        return this.foreachComplete(setIndex, (ClusterI.ObjectProcedure)procedure, context, support, modifier);
    }
}

