/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.procore.cluster.ClusterChangeSetI;
import org.simantics.db.service.ClusterUID;

class CCSParser {
    private static boolean DEBUG = false;

    CCSParser() {
    }

    static int parseStm(StmEnum stmEnum, Args args, byte[] bytes, int ap, int aBits, ReferenceType aPredicate, ReferenceType aObject) {
        assert (aBits <= 6);
        byte left = (byte)(6 - aBits);
        short ri = (short)((bytes[ap] & (1 << aBits) - 1) << 8 + left);
        Data pdata = new Data();
        ++ap;
        ap = CCSParser.getData(args.clusterUID, args.rft, bytes, ap, aPredicate, pdata);
        Data odata = new Data();
        ap = CCSParser.getData(args.clusterUID, args.rft, bytes, ap, aObject, odata);
        ri = (short)(ri | bytes[ap++] & 0xFF);
        short b = 0;
        int l = 0;
        if (left > 0) {
            b = (short)(bytes[ap++] & 0xFF);
            l = 8;
            byte t = (byte)b;
            t = (byte)(t & (1 << left) - 1);
            ri = (short)(ri | t << 8);
            l = (byte)(l - left);
            b = (short)(b >> left);
        }
        GetLeftArgs a = new GetLeftArgs(ap, b, (byte)l);
        CCSParser.getLeft(args.clusterUID, args.rft, bytes, pdata, a);
        CCSParser.getLeft(args.clusterUID, args.rft, bytes, odata, a);
        ap = a.p;
        if (DEBUG) {
            System.out.println(String.valueOf((Object)stmEnum) + " r=" + ri + " rc=" + String.valueOf(args.clusterUID) + " p=" + pdata.resource + " pc=" + String.valueOf(pdata.clusterUID) + " o=" + odata.resource + " oc=" + String.valueOf(odata.clusterUID));
        }
        if (ClusterUID.Null.equals((Object)args.clusterUID) || ClusterUID.Null.equals((Object)pdata.clusterUID) || ClusterUID.Null.equals((Object)odata.clusterUID)) {
            throw new RuntimeDatabaseException("Illegal cluster uid. args=" + String.valueOf(args));
        }
        switch (stmEnum) {
            case Add: {
                args.addRelation(ri, pdata.resource, pdata.clusterUID, odata.resource, odata.clusterUID);
                break;
            }
            case Remove: {
                args.removeRelation(ri, pdata.resource, pdata.clusterUID, odata.resource, odata.clusterUID);
                break;
            }
            default: {
                new RuntimeException("Internal error, unrecognized StmEnum value encountered: " + String.valueOf((Object)stmEnum));
            }
        }
        return ap;
    }

    private static void getLeft(ClusterUID aClusterUID, ForeignTable rft, byte[] bytes, Data rdata, GetLeftArgs a) {
        if (rdata.left) {
            if (a.l < 6) {
                a.b = (short)(a.b | (bytes[a.p] & 0xFF) << a.l);
                ++a.p;
                a.l = (byte)(a.l + 8);
            }
            byte t = (byte)a.b;
            t = (byte)(t & 0x3F);
            rdata.resource = (short)(rdata.resource | t << 8);
            rdata.left = false;
            if (rdata.clusterUID != aClusterUID) {
                rft.put(aClusterUID, rdata);
            }
            a.b = (short)(a.b >>> 6);
            a.l = (byte)(a.l - 6);
        } else {
            rft.getOrThrow(rdata.resource, rdata);
        }
    }

    private static int getData(ClusterUID aClusterUID, ForeignTable ft, byte[] bytes, int rp, ReferenceType a, Data rdata) {
        switch (a) {
            default: {
                throw new IllegalArgumentException("Illegal enumeration value=" + String.valueOf((Object)a) + ".");
            }
            case Local: {
                rdata.resource = (short)(bytes[rp] & 0xFF);
                rdata.clusterUID = aClusterUID;
                rdata.left = true;
                ++rp;
                break;
            }
            case ForeignShort: {
                rdata.resource = (short)(bytes[rp] & 0xFF);
                rdata.left = false;
                ++rp;
                break;
            }
            case ForeignLong: {
                rdata.clusterUID = ClusterUID.make((byte[])bytes, (int)rp);
                rdata.resource = (short)(bytes[rp += ClusterUID.getLongLength() * 8] & 0xFF);
                rdata.left = true;
                ++rp;
            }
        }
        return rp;
    }

    static long getLongN(byte[] bytes, int offset, int size) {
        long l = 0L;
        int i = 0;
        int shift = 0;
        while (i < size) {
            l |= (long)((bytes[offset] & 0xFF) << shift);
            ++i;
            ++offset;
            shift += 8;
        }
        return l;
    }

    static short getShort(byte[] bytes, int offset) {
        return (short)CCSParser.getLongN(bytes, offset, 2);
    }

    static int getInt(byte[] bytes, int offset) {
        return (int)CCSParser.getLongN(bytes, offset, 4);
    }

    static class Args {
        ClusterUID clusterUID;
        ForeignTable rft;
        ClusterChangeSetI.Operation rop;

        Args(ClusterUID clusterUID, ForeignTable rft, ClusterChangeSetI.Operation rop) {
            this.clusterUID = clusterUID;
            this.rft = rft;
            this.rop = rop;
        }

        void createResource(short aRI) {
            this.rop.type = ClusterChangeSetI.OperationEnum.CreateResource;
            this.rop.count = 1;
            this.rop.resourceIndex = aRI;
        }

        void addRelation(short aRI, short aPI, ClusterUID aPC, short aOI, ClusterUID aOC) {
            this.rop.type = ClusterChangeSetI.OperationEnum.AddRelation;
            this.rop.count = 5;
            this.rop.resourceIndex = aRI;
            this.rop.predicateIndex = aPI;
            this.rop.predicateCluster = aPC;
            this.rop.objectIndex = aOI;
            this.rop.objectCluster = aOC;
        }

        void removeRelation(short aRI, short aPI, ClusterUID aPC, short aOI, ClusterUID aOC) {
            this.rop.type = ClusterChangeSetI.OperationEnum.RemoveRelation;
            this.rop.count = 5;
            this.rop.resourceIndex = aRI;
            this.rop.predicateIndex = aPI;
            this.rop.predicateCluster = aPC;
            this.rop.objectIndex = aOI;
            this.rop.objectCluster = aOC;
        }

        void setValue(short aRI, byte[] apValueData, int valueStart, int aValueSize) {
            this.rop.type = ClusterChangeSetI.OperationEnum.SetValue;
            this.rop.count = 4;
            this.rop.resourceIndex = aRI;
            this.rop.valueSize = aValueSize;
            this.rop.valueData = apValueData;
            this.rop.valueStart = valueStart;
        }

        void deleteValue(short aRI) {
            this.rop.type = ClusterChangeSetI.OperationEnum.DeleteValue;
            this.rop.count = 1;
            this.rop.resourceIndex = aRI;
        }

        void modifyValue(short aRI, long aOffset, int aSize, byte[] apValue, int valueStart) {
            this.rop.type = ClusterChangeSetI.OperationEnum.ModifyValue;
            this.rop.count = 5;
            this.rop.resourceIndex = aRI;
            this.rop.valueOffset = aOffset;
            this.rop.valueSize = aSize;
            this.rop.valueData = apValue;
            this.rop.valueStart = valueStart;
        }
    }

    private static class Data {
        short resource = 0;
        ClusterUID clusterUID = ClusterUID.Null;
        boolean left = false;

        Data() {
        }
    }

    static class ForeignTable {
        private Data[] mTable = new Data[256];
        private int mSize;

        ForeignTable() {
            this.init();
        }

        void init() {
            this.mSize = 0;
        }

        boolean get(short key, Data data) {
            if (key < this.mSize) {
                data.resource = this.mTable[key].resource;
                data.clusterUID = this.mTable[key].clusterUID;
                data.left = this.mTable[key].left;
                return true;
            }
            return false;
        }

        void getOrThrow(short key, Data data) {
            if (key < this.mSize) {
                data.resource = this.mTable[key].resource;
                data.clusterUID = this.mTable[key].clusterUID;
                data.left = this.mTable[key].left;
            } else {
                new IllegalArgumentException("Missing foreign table entry for key=" + key + ".");
            }
        }

        void put(ClusterUID clusterUID, Data data) {
            if (this.mSize < 256) {
                if (DEBUG) {
                    System.out.println("ft put c=" + String.valueOf(clusterUID) + " i=" + this.mSize + " r=" + data.resource + " rc=" + String.valueOf(data.clusterUID));
                }
                if (data.resource == 0) {
                    throw new RuntimeDatabaseException("Resource can not be zero.");
                }
                if (data.clusterUID.equals((Object)ClusterUID.Null)) {
                    throw new RuntimeDatabaseException("Cluster can not be zero.");
                }
                this.mTable[this.mSize++] = data;
            }
        }
    }

    private static class GetLeftArgs {
        int p;
        short b;
        byte l;

        GetLeftArgs(int p, short b, byte l) {
            this.p = p;
            this.b = b;
            this.l = l;
        }
    }

    static enum ReferenceType {
        Local,
        ForeignShort,
        ForeignLong;

    }

    static enum StmEnum {
        Add,
        Remove;

    }
}

