/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

final class BitUtility {
    static final long LongBits = 64L;
    static final int IntBits = 32;
    static final short ShortBits = 16;
    static final long ClearHighIntMask = 0xFFFFFFFFL;
    static final long ClearLowIntMask = -4294967296L;
    static final long ClearHighShortMask = 65535L;
    static final long ClearLowShortMask = -65536L;

    BitUtility() {
    }

    static final int getHighInt(long longValue) {
        return (int)(longValue >>> 32);
    }

    static final long setHighInt(long longValue, int highValue) {
        longValue = longValue & 0xFFFFFFFFL | (long)highValue << 32;
        return longValue;
    }

    static final int getLowInt(long longValue) {
        return (int)longValue;
    }

    static final long setLowInt(long longValue, int lowValue) {
        longValue = longValue & 0xFFFFFFFF00000000L | (long)lowValue;
        return longValue;
    }

    static final long setLowAndHighInt(long longValue, int lowValue, int highValue) {
        longValue = (long)lowValue & 0xFFFFFFFFL | (long)highValue << 32;
        return longValue;
    }

    static final short getLowShort(long longValue) {
        return (short)longValue;
    }

    static final long setLowShort(long longValue, short lowValue) {
        longValue = longValue & 0xFFFFFFFFFFFF0000L | (long)lowValue & 0xFFFFL;
        return longValue;
    }

    static final int getMiddle(long longValue, int skip, int size) {
        return (int)(longValue >>> skip) & (1 << size) - 1;
    }

    static final long setMiddle(long longValue, int skip, int size, int value) {
        long a1 = (1L << size) - 1L;
        long m1 = a1 << skip;
        long mask = 0xFFFFFFFFFFFFFFFFL ^ m1;
        long t1 = ((long)value & a1) << skip;
        long t2 = longValue & mask;
        long t3 = t2 | t1;
        return t3;
    }
}

