/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClientChangesImpl;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContextI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import org.simantics.db.Database;
import org.simantics.db.SessionManager;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.procore.cluster.ClusterChangeSet;
import org.simantics.db.procore.cluster.ClusterChangeSetI;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.LifecycleSupport;

public class SynchronizeContext
implements SynchronizeContextI {
    private boolean DEBUG = false;
    private int changeSetsCount;
    private ChangeSet[] changeSets;
    private ClientChangesImpl clientChangesImpl;
    private SessionImplSocket session;
    private boolean endOfUpdate = false;
    private final boolean fetchOnly;
    private Vector<ClientChangesImpl> changes = new Vector();
    private String compressionCodec;

    SynchronizeContext(SessionImplSocket s, ClientChangesImpl clientChangesImpl, int N) {
        this(s, clientChangesImpl, N, false);
    }

    SynchronizeContext(SessionImplSocket s, ClientChangesImpl clientChangesImpl, int N, boolean fetchOnly) {
        this.session = s;
        this.clientChangesImpl = clientChangesImpl;
        this.changeSetsCount = 0;
        this.changeSets = new ChangeSet[N];
        this.fetchOnly = fetchOnly;
        LifecycleSupport support = this.session.getService(LifecycleSupport.class);
        SessionManager manager = support.getSessionManager();
        this.compressionCodec = manager.getDatabase().getCompression();
    }

    Collection<org.simantics.db.ChangeSet> getChangeSets() {
        Vector<org.simantics.db.ChangeSet> changeSets = new Vector<org.simantics.db.ChangeSet>(this.changes.size());
        for (ClientChangesImpl c : this.changes) {
            changeSets.add(c);
        }
        return changeSets;
    }

    public synchronized boolean isOk(boolean undo) throws DatabaseException {
        if (!this.endOfUpdate && this.changeSetsCount < this.changeSets.length) {
            try {
                boolean timeout;
                this.wait(10000L);
                boolean bl = timeout = this.changeSetsCount < this.changeSets.length;
                if (this.DEBUG && timeout) {
                    System.out.println("DEBUG: Synchronize context timeout.");
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.endOfUpdate && this.changeSetsCount != this.changeSets.length) {
            return false;
        }
        this.commitAndUpdate(undo);
        return true;
    }

    public synchronized void onChangeSetUpdate(Database.Session.ChangeSetUpdate event) throws ProCoreException {
        ClusterUID clusterUID = ClusterUID.make((byte[])event.getClusterId(), (int)0);
        if (this.DEBUG) {
            System.out.println("cs id " + event.getChangeSetId());
            System.out.println("cs index " + event.getChangeSetIndex());
            System.out.println("ccs N " + event.getNumberOfClusterChangeSets());
            System.out.println("ccs index " + event.getIndexOfClusterChangeSet());
            System.out.println("cluster=" + String.valueOf(clusterUID));
            if (event.getNewCluster()) {
                System.out.println("cluster is new");
            }
            System.out.println("data length " + event.getData().length);
            System.out.println(Arrays.toString(event.getData()));
        }
        if (0L == event.getChangeSetId() && (event.getChangeSetIndex() == 0 || this.changeSets.length == event.getChangeSetIndex()) && event.getNumberOfClusterChangeSets() == 0 && event.getIndexOfClusterChangeSet() == 0 && ClusterUID.Null.equals((Object)clusterUID)) {
            this.endOfUpdate = true;
            this.notify();
            return;
        }
        assert (this.changeSetsCount < this.changeSets.length);
        assert (event.getChangeSetIndex() < this.changeSets.length);
        assert (event.getIndexOfClusterChangeSet() < event.getNumberOfClusterChangeSets());
        ChangeSet cs = this.changeSets[event.getChangeSetIndex()];
        if (cs == null) {
            this.changeSets[event.getChangeSetIndex()] = cs = new ChangeSet(event.getChangeSetId(), event.getNumberOfClusterChangeSets());
        } else {
            assert (event.getChangeSetId() == cs.id);
            assert (event.getNumberOfClusterChangeSets() == cs.ccss.size());
            assert (cs.count < cs.ccss.size());
        }
        assert (event.getData().length > 0);
        if (this.DEBUG) {
            System.out.println("ccs count=" + cs.count);
        }
        cs.ccss3[event.getIndexOfClusterChangeSet()] = event.getNewCluster();
        cs.ccss.set(event.getIndexOfClusterChangeSet(), event.getData());
        ++cs.count;
        if (cs.count < cs.ccss.size()) {
            return;
        }
        ++this.changeSetsCount;
        if (this.changeSetsCount >= this.changeSets.length) {
            this.notify();
        }
    }

    private void commitAndUpdate(boolean undo) throws DatabaseException {
        int JSIZE;
        ChangeSet cs;
        int SIZE = this.changeSetsCount;
        if (this.DEBUG) {
            System.out.println("commitAndUpdate: cs count=" + SIZE);
        }
        int i = 0;
        while (i < SIZE) {
            cs = this.changeSets[i];
            JSIZE = cs.ccss.size();
            cs.ccss2 = new Vector(JSIZE);
            ClusterTable clusterTable = this.session.getClusterTable();
            cs.ccss2.setSize(JSIZE);
            int j = 0;
            while (j < JSIZE) {
                ClusterChangeSetI ccs = ClusterChangeSet.create(cs.ccss.get(j), this.compressionCodec);
                cs.ccss2.set(j, ccs);
                if (!this.fetchOnly) {
                    ClusterUID clusterUID;
                    ClusterImpl cluster;
                    if (cs.ccss3[j]) {
                        this.getClusterOrCreate(ccs.getClusterUID(), clusterTable);
                    }
                    if ((cluster = clusterTable.getClusterByClusterUID(clusterUID = ccs.getClusterUID())) == null) {
                        cs.skip[j] = true;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (this.fetchOnly) {
            this.changes.setSize(SIZE);
            i = 0;
            while (i < SIZE) {
                cs = this.changeSets[i];
                this.changes.set(i, new ClientChangesImpl(this.session));
                JSIZE = cs.ccss.size();
                int j = 0;
                while (j < JSIZE) {
                    ClusterChangeSetI ccs = cs.ccss2.get(j);
                    if (this.DEBUG) {
                        System.out.println("Update first pass. Cluster=" + String.valueOf(ccs.getClusterUID()) + " index=" + j);
                    }
                    this.updateSecondPass(ccs, this.changes.get(i));
                    ++j;
                }
                ++i;
            }
            return;
        }
        i = 0;
        while (i < SIZE) {
            cs = this.changeSets[i];
            JSIZE = cs.ccss.size();
            int j = 0;
            while (j < JSIZE) {
                ClusterChangeSetI ccs = cs.ccss2.get(j);
                if (cs.skip[j]) {
                    if (this.DEBUG) {
                        System.out.println("skipping change set " + String.valueOf(ccs.getClusterUID()));
                    }
                } else {
                    if (this.DEBUG) {
                        System.out.println("Update first pass. Cluster=" + String.valueOf(ccs.getClusterUID()) + " ccs=" + j);
                    }
                    this.updateFirstPass(ccs, undo);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < SIZE) {
            cs = this.changeSets[i];
            JSIZE = cs.ccss2.size();
            int j = 0;
            while (j < JSIZE) {
                ClusterChangeSetI ccs = cs.ccss2.get(j);
                if (cs.skip[j]) {
                    if (this.DEBUG) {
                        System.out.println("skipping change set " + String.valueOf(ccs.getClusterUID()));
                    }
                } else {
                    this.updateSecondPass(ccs, this.clientChangesImpl);
                }
                ++j;
            }
            ++i;
        }
    }

    private ClusterI getClusterOrCreate(ClusterUID clusterUID, ClusterTable clusterTable) {
        ClusterImpl cluster = clusterTable.getClusterByClusterUID(clusterUID);
        if (cluster == null) {
            cluster = clusterTable.getClusterByClusterUIDOrMakeProxy(clusterUID);
        }
        if (cluster != null) {
            // empty if block
        }
        return cluster;
    }

    private int getKey(long ri, ClusterUID clusterUID, ClusterTable clusterTable) throws DatabaseException {
        if (ri < 1L || ri > (long)ClusterTraits.getMaxNumberOfResources()) {
            throw new InternalException("Illegal resource index. index=" + ri + " cluster=" + String.valueOf(clusterUID));
        }
        if (!ClusterUID.isLegal((ClusterUID)clusterUID)) {
            throw new InternalException("Illegal resource cluster. index=" + ri + " cluster=" + String.valueOf(clusterUID));
        }
        ClusterImpl cluster = clusterTable.getClusterByClusterUIDOrMakeProxy(clusterUID);
        int key = ClusterTraits.createResourceKey((int)cluster.getClusterKey(), (int)((int)ri));
        if (key == 0) {
            throw new InternalException("Illegal resource index=" + ri + " cluster=" + String.valueOf(clusterUID));
        }
        return key;
    }

    private void updateFirstPass(ClusterChangeSetI ccs, boolean undo) throws DatabaseException {
        ClusterUID clusterUID;
        ClusterTable clusterTable = this.session.getClusterTable();
        ClusterImpl cluster = clusterTable.getClusterByClusterUID(clusterUID = ccs.getClusterUID());
        if (cluster == null) {
            throw new DatabaseException("Missing cluster id=" + String.valueOf(clusterUID));
        }
        if (!cluster.isLoaded()) {
            if (!undo) {
                return;
            }
            if (this.DEBUG) {
                System.out.println("Cluster is not loaded. cluster=" + String.valueOf(clusterUID));
            }
            cluster.load((ClusterSupport)this.session.clusterTranslator, new Runnable(){

                @Override
                public void run() {
                    if (SynchronizeContext.this.DEBUG) {
                        System.out.println("Cluster loaded for undo.");
                    }
                }
            });
            cluster = clusterTable.getClusterByClusterUIDOrMakeProxy(clusterUID);
        }
        ClusterChangeSetI.Operation op = new ClusterChangeSetI.Operation();
        ccs.getNextOperation(op);
        while (ClusterChangeSetI.OperationEnum.EndOf != op.type) {
            switch (op.type) {
                default: {
                    throw new InternalException("Unknown operation " + String.valueOf(op));
                }
                case CreateResource: {
                    int ss;
                    short ri;
                    int s;
                    if (op.count != 1) {
                        throw new InternalException("Illegal argument(s) to create resource.");
                    }
                    if (this.DEBUG) {
                        System.out.println("Create " + op.resourceIndex);
                    }
                    if (cluster.hasResource(s = this.getKey(op.resourceIndex, clusterUID, clusterTable), (ClusterSupport)this.session.clusterTranslator) || (ri = ClusterTraitsBase.getResourceIndexFromResourceKey((int)(ss = cluster.createResource((ClusterSupport)this.session.clusterTranslator)))) == op.resourceIndex) break;
                    throw new InternalException("Created resource key=" + ss + " does not match expected resource index=" + op.resourceIndex);
                }
                case AddRelation: {
                    ClusterI c;
                    if (op.count != 5) {
                        throw new InternalException("Illegal argument(s) to add relation");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    int p = this.getKey(op.predicateIndex, op.predicateCluster, clusterTable);
                    int o = this.getKey(op.objectIndex, op.objectCluster, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Add " + s + "-" + p + "-" + o);
                    }
                    if ((c = cluster.addRelation(s, p, o, (ClusterSupport)this.session.clusterTranslator)) == null || c == cluster) break;
                    cluster = c;
                    break;
                }
                case RemoveRelation: {
                    if (op.count != 5) {
                        throw new InternalException("Illegal argument(s) to remove relation");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    int p = this.getKey(op.predicateIndex, op.predicateCluster, clusterTable);
                    int o = this.getKey(op.objectIndex, op.objectCluster, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Remove " + s + "-" + p + "-" + o);
                    }
                    cluster.removeRelation(s, p, o, (ClusterSupport)this.session.clusterTranslator);
                    break;
                }
                case SetValue: {
                    if (op.count != 4) {
                        throw new InternalException("Illegal argument(s) to set value");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Set value " + s + " l=" + op.valueSize);
                    }
                    byte[] value = new byte[op.valueSize];
                    System.arraycopy(op.valueData, op.valueStart, value, 0, op.valueSize);
                    cluster = cluster.setValue(s, value, value.length, (ClusterSupport)this.session.clusterTranslator);
                    break;
                }
                case DeleteValue: {
                    if (op.count != 1) {
                        throw new InternalException("Illegal argument(s) to set value");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Delete " + s);
                    }
                    cluster.removeValue(s, (ClusterSupport)this.session.clusterTranslator);
                    break;
                }
                case ModifyValue: {
                    if (op.count != 5) {
                        throw new InternalException("Illegal argument(s) to modify resource file");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("ModifyValue " + s + " off=" + op.valueOffset + " siz=" + op.valueSize + " start=" + op.valueStart);
                    }
                    cluster.setValueEx(s);
                    if (!undo) break;
                    this.session.clusterTranslator.undoValueEx((Object)cluster, (int)op.resourceIndex);
                }
            }
            ccs.getNextOperation(op);
        }
    }

    private void updateSecondPass(ClusterChangeSetI ccs, ClientChangesImpl changes) throws DatabaseException {
        ClusterUID clusterUID;
        ClusterTable clusterTable;
        ClusterImpl cluster;
        if (this.DEBUG) {
            System.out.println("DEBUG: second pass cid=" + String.valueOf(ccs.getClusterUID()));
        }
        if ((cluster = (clusterTable = this.session.getClusterTable()).getClusterByClusterUID(clusterUID = ccs.getClusterUID())) == null) {
            if (this.fetchOnly) {
                cluster = clusterTable.getClusterByClusterUIDOrMakeProxy(clusterUID);
            } else {
                throw new DatabaseException("Missing cluster id=" + String.valueOf(clusterUID));
            }
        }
        if (!this.fetchOnly && !cluster.isLoaded()) {
            return;
        }
        ClusterChangeSetI.Operation op = new ClusterChangeSetI.Operation();
        ccs.getNextOperation(op);
        while (ClusterChangeSetI.OperationEnum.EndOf != op.type) {
            switch (op.type) {
                default: {
                    throw new InternalException("Unknown operation " + String.valueOf(op));
                }
                case CreateResource: {
                    if (op.count == 1) break;
                    throw new InternalException("Illegal argument(s) to create resource.");
                }
                case AddRelation: {
                    if (op.count != 5) {
                        throw new InternalException("Illegal argument(s) to add relation.");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    int p = this.getKey(op.predicateIndex, op.predicateCluster, clusterTable);
                    int o = this.getKey(op.objectIndex, op.objectCluster, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Add " + s + "-" + p + "-" + o);
                    }
                    if (!this.fetchOnly) {
                        this.session.getQueryProvider2().updateStatements(s, p);
                    }
                    changes.claim(s, p, o);
                    break;
                }
                case RemoveRelation: {
                    if (op.count != 5) {
                        throw new InternalException("Illegal argument(s) to remove relation.");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    int p = this.getKey(op.predicateIndex, op.predicateCluster, clusterTable);
                    int o = this.getKey(op.objectIndex, op.objectCluster, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Remove " + s + "-" + p + "-" + o);
                    }
                    if (!this.fetchOnly) {
                        this.session.getQueryProvider2().updateStatements(s, p);
                    }
                    changes.deny(s, p, o);
                    break;
                }
                case SetValue: {
                    if (op.count != 4) {
                        throw new InternalException("Illegal argument(s) to set value.");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Set value " + s + " l=" + op.valueSize);
                    }
                    if (!this.fetchOnly) {
                        this.session.getQueryProvider2().updateValue(s);
                    }
                    changes.claimValue(s);
                    break;
                }
                case DeleteValue: {
                    if (op.count != 1) {
                        throw new InternalException("Illegal argument(s) to remove value.");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("Delete value " + s);
                    }
                    if (!this.fetchOnly) {
                        this.session.getQueryProvider2().updateValue(s);
                    }
                    changes.claimValue(s);
                    break;
                }
                case ModifyValue: {
                    if (op.count != 5) {
                        throw new InternalException("Illegal argument(s) to modify resource file");
                    }
                    int s = this.getKey(op.resourceIndex, clusterUID, clusterTable);
                    if (this.DEBUG) {
                        System.out.println("ModifyValue " + s + " off=" + op.valueOffset + " siz=" + op.valueSize + " start=" + op.valueStart);
                    }
                    if (!this.fetchOnly) {
                        this.session.getQueryProvider2().updateValue(s);
                        break;
                    }
                    changes.claimValue(s);
                }
            }
            ccs.getNextOperation(op);
        }
    }

    class ChangeSet {
        long id;
        int count;
        Vector<byte[]> ccss;
        Vector<ClusterChangeSetI> ccss2;
        boolean[] ccss3;
        boolean[] skip;

        ChangeSet(long id, int size) {
            this.id = id;
            this.count = 0;
            this.ccss = new Vector(size);
            this.ccss.setSize(size);
            this.ccss3 = new boolean[size];
            this.skip = new boolean[size];
        }
    }
}

