package fi.vtt.simantics.procore.internal;

import gnu.trove.list.array.TByteArrayList;

import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.service.ClusterBuilder2;
import org.simantics.db.service.SerialisationSupport;

public class VirtualClusterBuilderImpl2 implements ClusterBuilder2 {

	final private SessionImplSocket session;
	final private VirtualGraph vg;
//    final private ClusterSupport cs;
    final private SerialisationSupport ss;
//    final private ClusterStream stream;
//    final private WriteSupport support;
//    final private WriteSupport support;
    @SuppressWarnings("unused")
    final private boolean allowImmutables;
    
    VirtualClusterBuilderImpl2(SessionImplSocket session, VirtualGraph vg, boolean allowImmutables) {
    	this.session = session;
    	this.vg = vg;
        this.allowImmutables = allowImmutables;
        ss = session.getService(SerialisationSupport.class);
    }
    
    private WriteSupport getSupport() {
        WriteGraphImpl graph = session.writeState.getGraph();
        return graph.writeSupport;
    }

    @Override
    public void newCluster() throws DatabaseException {
    	// Do nothing
    }

    @Override
    public void selectCluster(long cluster) throws DatabaseException {
    	// Do nothing
    }
    
    @Override
    public void newCluster(int setHandle) throws DatabaseException {
    	// Do nothing
    }
    
    @Override
    public void createClusterSet(int resource) throws DatabaseException {
    	// Do nothing
    }
    
    @Override
    public int newResource() throws DatabaseException {
    	Resource result = getSupport().createResource(vg); 
    	return handle(result);
    }

    @Override
    public int newResource(int set) throws DatabaseException {
    	Resource result = getSupport().createResource(vg, resource(set));
    	return handle(result);
    }
    
    @Override
    public int resource(Resource res) throws DatabaseException {
        ResourceImpl r = (ResourceImpl)res;
        return r.id;
    }

    @Override
    public void addStatement(WriteOnlyGraph graph, int subject, int predicate, int object) throws DatabaseException {
    	getSupport().claim(vg, subject, predicate, object);
    }
    
//    public void applyPredicate(ClusterImpl impl, int predicate) {
//        
//        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(predicate);
//        ClusterImpl cluster = clusterArray[clusterKey]; 
//        
//        impl.change.addStatementIndex1(predicate, cluster.clusterUID, (byte)0, impl.foreignLookup);
//        
//    }
//
//    public void applyObject(ClusterImpl impl, int object) {
//
//        int clusterKey = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(object);
//        ClusterImpl cluster = clusterArray[clusterKey]; 
//        
//        impl.change.addStatementIndex2(object, cluster.clusterUID, (byte)0, impl.foreignLookup);
//        
//    }

    @Override
    public Resource resource(int key) {
        try {
            return ss.getResource(key);
        } catch (DatabaseException e) {
            throw new RuntimeDatabaseException(e);
        }
    }
    
    @Override
    public int handle(Resource r) {
        return ((ResourceImpl)r).id;
    }


    TByteArrayList valueBytes = new TByteArrayList();
    
//    byte[] buffer = new byte[65536];
//    int bufferOffset = 0;
    int valueSubject = 0;
//    int valueOffset = 0;
    
    @Override
    public void beginValue(int subject) {
    	valueBytes.clear();
        valueSubject = subject;
    }
        
    @Override
    public void appendValue(int byteValue) throws DatabaseException {
    	valueBytes.add((byte)byteValue);
    }

    @Override
    public void endValue() throws DatabaseException {
    	byte[] bytes = valueBytes.toArray();
    	getSupport().claimValue(vg, valueSubject, bytes, bytes.length);
    }
    
}
