package fi.vtt.simantics.procore.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.util.binary.OutputStreamWriteable;

/**
 * @author Tuukka Lehtonen
 * @since 1.60.0
 */
public class Serialization {

	public static byte[] toByteArray(int initialSize, Binding binding, Object value) throws IOException {
		try (var baos = new ByteArrayOutputStream(initialSize)) {
			Bindings
			.getSerializerUnchecked(Bindings.VARIANT)
			.serialize(
					new OutputStreamWriteable(baos),
					new MutableVariant(binding, value));
			return baos.toByteArray();
		}
	}

}
