/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package fi.vtt.simantics.procore.internal;

import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.support.ResourceSupport;

final public class DirectStatementImpl implements Statement {

	final ResourceSupport support;
	final int s;
	final int p;
	final int o;
	
	DirectStatementImpl(ResourceSupport support, int s, int p, int o) {
		this.support = support;
		this.s = s;
		this.p = p;
		this.o = o;
	}

	@Override
	public Resource getObject() {
		return new ResourceImpl(support, o);
	}

	@Override
	public Resource getPredicate() {
		return new ResourceImpl(support, p);
	}

	@Override
	public Resource getSubject() {
		return new ResourceImpl(support, s);
	}

	@Override
	public boolean isAsserted(Resource subject) {
		return false;
	}
	
    @Override
    final public int hashCode() {
        return 41 * ( 31 * s + p) + o;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof Statement))
            return false;
        Statement r = (Statement)object;
        return getSubject().equalsResource(r.getSubject()) && getPredicate().equalsResource(r.getPredicate()) && getObject().equalsResource(r.getObject());
    }
}
