package fi.vtt.simantics.procore.internal;

import org.simantics.db.service.ClusterUID;

final public class Change {
    
    byte op0;
    int key0;
    int key1;
    int key2;
    ClusterUID clusterUID1;
    ClusterUID clusterUID2;
    byte[] lookup1;
    byte[] lookup2;
    byte lookIndex1;
    byte lookIndex2;
    int lastArg = 0;

    @Override
    public String toString() {
        return "Change " + (key0&0xffff) + " " + (key1&0xffff) + " " + (key2&0xffff) + " " + clusterUID2 + " " + clusterUID2;
    }
    
    public final void init() {
        lastArg = 0;
    }

    public final void initValue() {
        lastArg = 0;
    }

    final void addStatementIndex0(int key, byte op) {
        assert (op != 0);
        key0 = key;
        op0 = op;
    }

    final void addStatementIndex1(int key, ClusterUID clusterUID, byte lookIndex, byte[] lookup) {
        key1 = key;
        clusterUID1 = clusterUID;
        lookIndex1 = lookIndex;
        lookup1 = lookup;
//        if(lookIndex > 0)
//            System.err.println("statementIndex1 " + pos + " " + lookIndex);
    }

    final void addStatementIndex2(int key, ClusterUID clusterUID, byte lookIndex, byte[] lookup) {
        key2 = key;
        clusterUID2 = clusterUID;
        lookIndex2 = lookIndex;
        lookup2 = lookup;
    }

    final void addStatementIndex(int key, ClusterUID clusterUID, byte op) {

        // new Exception("lastArg=" + lastArg).printStackTrace();

        assert (lastArg < 3);

        if (0 == lastArg)
            addStatementIndex0(key, op);
        else if (1 == lastArg)
            addStatementIndex1(key, clusterUID, (byte)0, null);
        else if (2 == lastArg)
            addStatementIndex2(key, clusterUID, (byte)0, null);

        lastArg++;

    }
}
