/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Collection;
import java.util.Collections;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

public interface VariableSpaceManipulator {
    public void apply(WriteGraph var1, Modification var2) throws DatabaseException;

    public static class ChildCreationData {
        public String type;
        public String name;
        public PropertyCreationData[] properties;

        public ChildCreationData(String name, String type, PropertyCreationData[] properties) {
            this.name = name;
            this.type = type;
            this.properties = properties;
        }

        public static ChildCreationData build(String name, String type, PropertyCreationData ... properties) {
            return new ChildCreationData(name, type, properties);
        }
    }

    public static class Modification {
        public String[] removedProperties;
        public String[] removedChildren;
        public PropertyCreationData[] newProperties;
        public ChildCreationData[] newChildren;

        public Modification(String[] removedProperties, String[] removedChildren, PropertyCreationData[] newProperties, ChildCreationData[] newChildren) {
            this.removedProperties = removedProperties;
            this.removedChildren = removedChildren;
            this.newProperties = newProperties;
            this.newChildren = newChildren;
        }

        public static Modification build(Collection<String> removedProperties, Collection<String> removedChildren, Collection<PropertyCreationData> newProperties, Collection<ChildCreationData> newChildren) {
            return new Modification(removedProperties.toArray(new String[removedProperties.size()]), removedChildren.toArray(new String[removedChildren.size()]), newProperties.toArray(new PropertyCreationData[newProperties.size()]), newChildren.toArray(new ChildCreationData[newChildren.size()]));
        }

        public static Modification buildChildren(Collection<String> removedChildren, Collection<ChildCreationData> newChildren) {
            return new Modification(new String[0], removedChildren.toArray(new String[removedChildren.size()]), new PropertyCreationData[0], newChildren.toArray(new ChildCreationData[newChildren.size()]));
        }

        public static Modification addChildren(Collection<ChildCreationData> newChildren) {
            return new Modification(new String[0], new String[0], new PropertyCreationData[0], newChildren.toArray(new ChildCreationData[newChildren.size()]));
        }

        public static Modification addChild(ChildCreationData child) {
            return Modification.addChildren(Collections.singletonList(child));
        }

        public static Modification removeChildren(Collection<String> removedChildren) {
            return new Modification(new String[0], removedChildren.toArray(new String[removedChildren.size()]), new PropertyCreationData[0], new ChildCreationData[0]);
        }

        public static Modification removeChild(String child) {
            return Modification.removeChildren(Collections.singletonList(child));
        }

        public static Modification addProperties(Collection<PropertyCreationData> newProperties) {
            return new Modification(new String[0], new String[0], newProperties.toArray(new PropertyCreationData[newProperties.size()]), new ChildCreationData[0]);
        }

        public static Modification addProperty(PropertyCreationData property) {
            return Modification.addProperties(Collections.singletonList(property));
        }
    }

    public static class PropertyCreationData {
        public String name;
        public Variant value;

        public PropertyCreationData(String name, Variant value) {
            this.name = name;
            this.value = value;
        }

        public static PropertyCreationData build(String name, Object value) {
            return new PropertyCreationData(name, Variant.ofInstance((Object)value));
        }
    }
}

