/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import java.util.Objects;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variables;

public class VariableReference {
    public final RVI variableId;
    public final Datatype datatype;
    public String itemId;
    public String label;

    public static VariableReference of(RVI variableId, Datatype datatype, String label) {
        return new VariableReference(variableId, datatype, label);
    }

    public static VariableReference of(String itemId, RVI variableId, Datatype datatype, String label) {
        return new VariableReference(itemId, variableId, datatype, label);
    }

    public VariableReference(String itemId, RVI variableId, Datatype datatype, String label) {
        this.itemId = itemId;
        this.variableId = variableId;
        this.datatype = datatype;
        this.label = label;
    }

    public VariableReference(RVI variableId, Datatype datatype, String label) {
        this(null, variableId, datatype, label);
    }

    public String getItemId() {
        return this.itemId;
    }

    public RVI getVariableId() {
        return this.variableId;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return (Objects.hashCode(this.itemId) * 31 + Objects.hashCode(this.datatype)) * 31 + Objects.hashCode((Object)this.variableId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableReference other = (VariableReference)obj;
        return Objects.equals(this.itemId, other.itemId) && this.variableId.equals((Object)other.variableId) && Objects.equals(this.datatype, other.datatype);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.variableId != null) {
            sb.append((Object)this.variableId);
        }
        if (this.itemId != null) {
            sb.append(this.itemId);
        }
        if (this.datatype != null) {
            sb.append(" : ").append(this.datatype.toSingleLineString());
        }
        if (this.label != null) {
            sb.append(" (").append(this.label).append(")");
        }
        return sb.toString();
    }

    public boolean containsPartWithRole(Variables.Role role) {
        if (this.variableId == null) {
            return false;
        }
        RVI.RVIPart[] rVIPartArray = this.variableId.parts;
        int n = this.variableId.parts.length;
        int n2 = 0;
        while (n2 < n) {
            RVI.RVIPart p = rVIPartArray[n2];
            if (p.getRole() == role) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

