/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnvironmentRequest
extends UnaryRead<Resource, Pair<EnvironmentSpecification, Environment>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvironmentRequest.class);

    public EnvironmentRequest(Resource parameter) {
        super((Object)parameter);
    }

    protected abstract void fillEnvironmentSpecification(EnvironmentSpecification var1);

    protected abstract String getRootModuleName();

    public static void getEnvironment(final EnvironmentSpecification environmentSpecification, Listener<Environment> callback, final UpdateListenerImpl listener) {
        try {
            Environment env;
            SCLContext context = SCLContext.getCurrent();
            Object graph = context.get((Object)"graph");
            if (graph == null) {
                try {
                    env = (Environment)SimanticsInternal.getSession().syncRequest((Read)new Read<Environment>(){

                        public Environment perform(ReadGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.get((Object)"graph");
                            try {
                                sclContext.put((Object)"graph", (Object)graph);
                                Environment environment = SCLOsgi.MODULE_REPOSITORY.createEnvironment(environmentSpecification, (UpdateListener)listener);
                                return environment;
                            }
                            catch (ImportFailureException e) {
                                throw new DatabaseException((Throwable)e);
                            }
                            catch (Throwable t) {
                                throw new DatabaseException(t);
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    LOGGER.error("Finding environment failed", (Throwable)e);
                    callback.exception((Throwable)e);
                    return;
                }
            } else {
                env = SCLOsgi.MODULE_REPOSITORY.createEnvironment(environmentSpecification, (UpdateListener)listener);
            }
            callback.execute((Object)env);
        }
        catch (ImportFailureException e) {
            LOGGER.error("Finding environment failed", (Throwable)e);
            callback.exception((Throwable)new DatabaseException((Throwable)e));
        }
    }

    public Pair<EnvironmentSpecification, Environment> perform(ReadGraph graph) throws DatabaseException {
        Object mainModuleUri;
        final EnvironmentSpecification environmentSpecification = EnvironmentSpecification.of((String[])new String[]{"Builtin", "", "StandardLibrary", ""});
        this.fillEnvironmentSpecification(environmentSpecification);
        Resource mainModule = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)((Resource)this.parameter), (String)this.getRootModuleName());
        if (mainModule != null) {
            mainModuleUri = graph.getURI(mainModule);
            environmentSpecification.importModule((String)mainModuleUri, "");
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            for (Resource l : graph.getObjects((Resource)this.parameter, L0.IsLinkedTo)) {
                mainModule = CommonDBUtils.getPossibleChild((ReadGraph)graph, (Resource)l, (String)"SCLMain");
                if (mainModule == null) continue;
                environmentSpecification.importModule(graph.getURI(mainModule), "");
            }
        } else {
            mainModuleUri = graph.getURI((Resource)this.parameter) + "/#";
        }
        try {
            return Pair.make((Object)environmentSpecification, (Object)((Environment)graph.syncRequest((ExternalRead)new ParametrizedPrimitiveRead<String, Environment>((String)mainModuleUri){
                UpdateListenerImpl sclListener;

                public void register(ReadGraph graph, Listener<Environment> procedure) {
                    SCLContext context = SCLContext.getCurrent();
                    Object oldGraph = context.put((Object)"graph", (Object)graph);
                    try {
                        if (procedure.safeIsDisposed()) {
                            EnvironmentRequest.getEnvironment(environmentSpecification, procedure, null);
                        } else {
                            this.sclListener = new UpdateListenerImpl(environmentSpecification, procedure);
                            this.sclListener.notifyAboutUpdate();
                        }
                    }
                    finally {
                        context.put((Object)"graph", oldGraph);
                    }
                }

                public void unregistered() {
                    if (this.sclListener != null) {
                        this.sclListener.stopListening();
                    }
                }
            })));
        }
        catch (DatabaseException e) {
            LOGGER.error("Environment request failed", (Throwable)e);
            throw e;
        }
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + super.hashCode();
    }

    static class UpdateListenerImpl
    extends UpdateListener {
        final EnvironmentSpecification environmentSpecification;
        final Listener<Environment> callback;

        UpdateListenerImpl(EnvironmentSpecification environmentSpecification, Listener<Environment> callback) {
            this.environmentSpecification = environmentSpecification;
            this.callback = callback;
        }

        public void notifyAboutUpdate() {
            if (this.callback.safeIsDisposed()) {
                this.stopListening();
                return;
            }
            EnvironmentRequest.getEnvironment(this.environmentSpecification, this.callback, this);
        }
    }
}

