/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnescapedAssertedPropertyMapOfResource
extends ResourceRead<Map<String, Pair<PropertyInfo, Resource>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnescapedAssertedPropertyMapOfResource.class);

    public UnescapedAssertedPropertyMapOfResource(Resource resource) {
        super(resource);
    }

    public Map<String, Pair<PropertyInfo, Resource>> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection assertions = graph.getAssertedStatements(this.resource, L0.HasProperty);
        THashMap result = new THashMap(assertions.size());
        for (Statement stm : assertions) {
            String name;
            PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(stm.getPredicate()), (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (info == null || !info.isHasProperty || result.putIfAbsent((Object)(name = info.name), (Object)Pair.make((Object)info, (Object)stm.getObject())) == null || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(String.valueOf((Object)this) + ": The database resource $" + this.resource.getResourceId() + " asserts the multiple properties with the same name " + name + " (resource=$" + info.predicate.getResourceId() + ").");
        }
        return result;
    }
}

