/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceMultiRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.request.NamespaceRequirements;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.request.MultiRead;
import org.simantics.layer0.Layer0;
import org.simantics.project.ontology.ProjectResource;

public class OntologiesForModel
extends ResourceMultiRead<Resource> {
    public OntologiesForModel(Resource model) {
        super(model);
    }

    public void check(ReadGraph graph, Resource resource, SyncMultiProcedure<Resource> callback) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(resource, PROJ.RequiresNamespace)) {
            if (!graph.isInstanceOf(r, L0.URI)) continue;
            String uri = (String)graph.getValue(r);
            try {
                Resource ns = graph.getResource(uri);
                if (!graph.isInstanceOf(ns, L0.Ontology)) continue;
                callback.execute(graph, (Object)ns);
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void perform(ReadGraph graph, SyncMultiProcedure<Resource> callback) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource project = graph.getSingleObject(this.resource, L0.PartOf);
        for (Resource feature : graph.syncRequest((MultiRead)new NamespaceRequirements(project))) {
            this.check(graph, feature, callback);
        }
        callback.finished(graph);
    }
}

