/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.migration.NamespaceMigrationStep;
import org.simantics.db.layer0.migration.NullWriter;
import org.simantics.db.request.WriteInterface;
import org.simantics.graph.query.Path;
import org.simantics.graph.refactoring.MappingSpecification;
import org.simantics.layer0.Layer0;

public class SLNamespaceMigrationStep
extends NamespaceMigrationStep {
    public SLNamespaceMigrationStep(ReadGraph graph, Resource step) throws DatabaseException {
        super(graph, step);
    }

    @Override
    public void applyTo(final IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Collection roots = (Collection)state.getProperty("currentRootResources");
        if (roots.isEmpty()) {
            return;
        }
        final PrintWriter log = MigrationUtils.getProperty(state, "messageLogWriter", NullWriter.PRINT_INSTANCE);
        session.sync((WriteInterface)new DelayedWriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                SLNamespaceMigrationStep.this.create(monitor, graph, roots, log);
            }
        });
    }

    private void create(IProgressMonitor monitor, WriteGraph graph, Collection<Resource> roots, PrintWriter log) throws DatabaseException {
        MappingSpecification mappingSpec = new MappingSpecification((Collection)this.rules);
        log.println("## NameSpace migration for a Shared Library\n");
        HashMap<Path, Resource> pathMap = new HashMap<Path, Resource>();
        for (MappingSpecification.MappingRule mr : mappingSpec.rules) {
            Resource res;
            String uri;
            if (!pathMap.containsKey(mr.from)) {
                uri = mr.from.toString();
                res = graph.getResource(uri);
                pathMap.put(mr.from, res);
                if (res == null) {
                    log.print("Didn't find " + String.valueOf(mr.from));
                }
            }
            if (pathMap.containsKey(mr.to)) continue;
            uri = mr.to.toString();
            res = graph.getResource(uri);
            pathMap.put(mr.to, res);
            if (res != null) continue;
            log.print("Didn't find " + String.valueOf(mr.to));
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ArrayDeque<Resource> stack = new ArrayDeque<Resource>();
        stack.addAll(roots);
        while (!stack.isEmpty()) {
            Resource r = (Resource)stack.pop();
            stack.addAll(graph.getObjects(r, L0.ConsistsOf));
            for (MappingSpecification.MappingRule mr : mappingSpec.rules) {
                Resource fromPred = (Resource)pathMap.get(mr.from);
                Resource toPred = (Resource)pathMap.get(mr.to);
                if (fromPred == null || toPred == null) continue;
                Collection stms = graph.getStatements(r, fromPred);
                for (Statement stm : stms) {
                    if (stm.isAsserted(r)) continue;
                    graph.deny(stm);
                    graph.claim(stm.getSubject(), toPred, stm.getObject());
                }
            }
        }
    }
}

