/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.migration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationStep;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;

public class OrderedSetToListMigrationStep
implements MigrationStep {
    final ArrayList<OrderedSetToListMapping> rules = new ArrayList();

    public OrderedSetToListMigrationStep(ReadGraph graph, Resource step) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource change : ListUtils.toList((ReadGraph)graph, (Resource)step)) {
            String entityType = (String)graph.getPossibleRelatedValue(change, L0.OrderedSetToListMigrationStep_entityType, (Binding)Bindings.STRING);
            String orderedSet = (String)graph.getPossibleRelatedValue(change, L0.OrderedSetToListMigrationStep_orderedSetType, (Binding)Bindings.STRING);
            String orderedSetRelation = (String)graph.getPossibleRelatedValue(change, L0.OrderedSetToListMigrationStep_orderedSetRelation, (Binding)Bindings.STRING);
            String list = (String)graph.getPossibleRelatedValue(change, L0.OrderedSetToListMigrationStep_listType, (Binding)Bindings.STRING);
            String listRelation = (String)graph.getPossibleRelatedValue(change, L0.OrderedSetToListMigrationStep_listRelation, (Binding)Bindings.STRING);
            if (orderedSet == null || orderedSetRelation == null || list == null || listRelation == null) continue;
            OrderedSetToListMapping mapping = new OrderedSetToListMapping();
            mapping.entityType = graph.getResource(entityType);
            mapping.orderedSet = graph.getResource(orderedSet);
            mapping.orderedSetRelation = graph.getResource(orderedSetRelation);
            mapping.list = graph.getResource(list);
            mapping.listRelation = graph.getResource(listRelation);
            this.rules.add(mapping);
        }
    }

    @Override
    public void applyTo(IProgressMonitor monitor, Session session, MigrationState state) throws DatabaseException {
        final Resource resource = MigrationUtils.getResource(monitor, session, state);
        if (resource != null) {
            session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    for (OrderedSetToListMapping mapping : OrderedSetToListMigrationStep.this.rules) {
                        Instances entityFinder = (Instances)graph.adapt(mapping.entityType, Instances.class);
                        for (Resource entity : entityFinder.find((ReadGraph)graph, resource)) {
                            Resource orderedSet = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(entity, mapping.orderedSetRelation, mapping.orderedSet));
                            if (orderedSet == null) continue;
                            List list = OrderedSetUtils.toList((ReadGraph)graph, (Resource)orderedSet);
                            graph.deny(entity, mapping.orderedSetRelation, orderedSet);
                            graph.claim(entity, mapping.listRelation, ListUtils.create((WriteGraph)graph, (Resource)mapping.list, (Iterable)list));
                        }
                    }
                }
            });
        }
    }

    private class OrderedSetToListMapping {
        public Resource entityType;
        public Resource orderedSet;
        public Resource orderedSetRelation;
        public Resource list;
        public Resource listRelation;

        private OrderedSetToListMapping() {
        }
    }
}

