/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.adapter.impl.EntityNameModifier;
import org.simantics.layer0.Layer0;

public final class RelatedEntityNameModifier
implements StringModifier {
    private EntityNameModifier entityModifier;
    private Resource entity;
    private Resource relation;

    public RelatedEntityNameModifier(ReadGraph graph, Resource entity, Resource property, Resource relation) throws DatabaseException {
        this.entityModifier = new EntityNameModifier(graph, entity, property);
        this.entity = entity;
        this.relation = relation;
    }

    @Override
    public String getValue() {
        return this.entityModifier.getValue();
    }

    @Override
    public String isValid(String value) {
        return this.entityModifier.isValid(value);
    }

    @Override
    public final void modify(WriteGraph graph, String value) throws DatabaseException {
        graph.markUndoPoint();
        this.entityModifier.modify(graph, value);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String v = this.entityModifier.finalValue(value);
        for (Resource related : graph.getObjects(this.entity, this.relation)) {
            graph.claimLiteral(related, L0.HasName, L0.NameOf, (Object)v, (Binding)Bindings.STRING);
        }
    }
}

