package org.simantics.db.layer0.variable;

import java.util.Objects;

import org.simantics.databoard.type.Datatype;
import org.simantics.db.layer0.variable.Variables.Role;

/**
 * @author Tuukka Lehtonen
 */
public class VariableReference {

    public final RVI variableId;

    public final Datatype datatype;

    public String itemId;

    public String label;

    public static VariableReference of(RVI variableId, Datatype datatype, String label) {
        return new VariableReference(variableId, datatype, label);
    }

    public static VariableReference of(String itemId, RVI variableId, Datatype datatype, String label) {
        return new VariableReference(itemId, variableId, datatype, label);
    }

    public VariableReference(String itemId, RVI variableId, Datatype datatype, String label) {
        this.itemId = itemId;
        this.variableId = variableId;
        this.datatype = datatype;
        this.label = label;
    }

    public VariableReference(RVI variableId, Datatype datatype, String label) {
    	this(null, variableId, datatype, label);
    }

    public String getItemId() {
    	return itemId;
    }
    
    public RVI getVariableId() {
        return variableId;
    }

    public Datatype getDatatype() {
        return datatype;
    }

    public String getLabel() {
        return label;
    }

    @Override
    public int hashCode() {
        return (Objects.hashCode(itemId) * 31 + Objects.hashCode(datatype)) * 31 + Objects.hashCode(variableId);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        VariableReference other = (VariableReference) obj;
        return Objects.equals(itemId, other.itemId) && variableId.equals(other.variableId) && Objects.equals(datatype, other.datatype);
//                && Objects.equals(label, other.label);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (variableId != null)
            sb.append(variableId);
        if (itemId != null)
            sb.append(itemId);
        if (datatype != null)
            sb.append(" : ").append(datatype.toSingleLineString());
        if (label != null)
            sb.append(" (").append(label).append(")");
        return sb.toString();
    }

    public boolean containsPartWithRole(Role role) {
        if (variableId == null)
            return false;
        for (var p : variableId.parts) {
            if (p.getRole() == role) {
                return true;
            }
        }
        return false;
    }

}
