package org.simantics.db.layer0.request;

import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.ReadExt;
import org.simantics.db.request.RequestFlags;

public class ResourceURIToVariable extends UnaryRead<String, Variable> implements ReadExt {

	public ResourceURIToVariable(String uri) {
		super(uri);
	}
	
    public static int split(String uri) {
        int pos = uri.lastIndexOf(URIStringUtils.NAMESPACE_PATH_SEPARATOR);
        int pos2 = uri.lastIndexOf(URIStringUtils.NAMESPACE_LOCAL_SEPARATOR);
        return Math.max(pos, pos2);
    }
	
	@Override
	public Variable perform(ReadGraph graph) throws DatabaseException {
		
        if("http://".equals(parameter) || "http:/".equals(parameter)) {
        	return new StandardGraphChildVariable(null, null, graph.getRootLibrary());
        } else {
            int childPos = parameter.lastIndexOf(URIStringUtils.NAMESPACE_PATH_SEPARATOR);
            int propertyPos = parameter.lastIndexOf(URIStringUtils.NAMESPACE_LOCAL_SEPARATOR);
            if(childPos > propertyPos)  {
                Variable parent = graph.syncRequest(new ResourceURIToVariable(parameter.substring(0, childPos)));
                return parent.getChild(graph, URIStringUtils.unescape(parameter.substring(childPos + 1, parameter.length())));
            } else {
                Variable parent = graph.syncRequest(new ResourceURIToVariable(parameter.substring(0, propertyPos)));
                return parent.getProperty(graph, URIStringUtils.unescape(parameter.substring(propertyPos + 1, parameter.length())));
            }
        }
        
	}

    @Override
    public boolean isImmutable(ReadGraph graph) {
        return false;
    }

	@Override
	public int getType() {
		return RequestFlags.INVALIDATE;
	}

}
