/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

/**
 * @author Tuukka Lehtonen
 * @since 1.28.0
 */
public class PossibleVariableRepresents extends VariableRead<Resource> {

    public PossibleVariableRepresents(Variable var) {
        super(var);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
        return variable.getPossibleRepresents(graph);
    }

}
