package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 * @since 1.25.0
 */
public class LinkedFrom extends ResourceRead<Set<Resource>> {

    public LinkedFrom(Resource resource) {
        super(resource);
    }

    @Override
    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        HashSet<Resource> result = new HashSet<>();
        Collection<Resource> linkees = graph.getObjects(resource, L0.IsLinkedTo_Inverse);
        result.addAll(linkees);
        for (Resource linkee : linkees) {
            Set<Resource> deep = graph.sync(new LinkedFrom(linkee));
            result.addAll(deep);
        }
        return result;
    }

}
