/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.QueryProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryCollectorImpl
implements QueryProcessor.QueryCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryCollectorImpl.class);
    private static final boolean DEBUG = false;
    private final QueryProcessor queryProcessor;
    private final QueryProcessor.QueryCollectorSupport support;
    boolean doneAll = false;
    int moreAll = 0;
    boolean propagate = true;
    private static final int COLLECT_N = 1000;
    private long spent = 0L;

    QueryCollectorImpl(QueryProcessor queryProcessor, QueryProcessor.QueryCollectorSupport support) {
        this.queryProcessor = queryProcessor;
        this.support = support;
    }

    @Override
    public void collect(int youngTarget, int allowedTimeInMs) {
        this.queryProcessor.waitBarrier(() -> {
            this.queryProcessor.listening.stopThreading();
            this.collect_(youngTarget, allowedTimeInMs);
            this.queryProcessor.listening.startThreading();
        });
    }

    public void collect_(int youngTarget, int allowedTimeInMs) {
        long start = System.nanoTime();
        boolean requestFlush = youngTarget == 0;
        boolean newData = this.support.start(requestFlush);
        if (newData) {
            long actPct;
            this.moreAll = 0;
            CacheEntryBase prospect = this.support.iterate(0);
            while (prospect != null) {
                if (prospect.isDiscarded()) {
                    this.support.remove();
                    this.propagate = true;
                } else {
                    CacheEntry parent = this.queryProcessor.listening.firstParentNotDiscarded(prospect);
                    if (parent == null) {
                        this.tryCollect(prospect);
                    } else {
                        short nextLevel = parent.getLevel();
                        nextLevel = (short)(nextLevel + 1);
                        this.support.setLevel(prospect, nextLevel);
                    }
                }
                prospect = this.support.iterate(0);
            }
            int size = this.support.calculateCurrentSize();
            long act = this.support.getActivity();
            long l = actPct = size > 0 ? 100L * act / (long)size : 0L;
            if (!this.propagate && actPct < (long)youngTarget) {
                return;
            }
        }
        long test = (long)allowedTimeInMs * 1000000L;
        this.start();
        block1: while (true) {
            boolean timeCondition;
            int size = this.support.getCurrentSize();
            long elapsed = System.nanoTime() - start;
            boolean bl = timeCondition = elapsed > test;
            if (this.doneAll || timeCondition) {
                this.spent += elapsed;
                return;
            }
            if (this.doneAll) continue;
            int i = 0;
            while (true) {
                if (i >= 1000) continue block1;
                CacheEntryBase entry = this.support.iterate(Integer.MAX_VALUE);
                if (entry == null) {
                    if (this.moreAll < 1000) {
                        this.doneAll = true;
                        this.propagate = false;
                    }
                    this.moreAll = 0;
                    continue block1;
                }
                CacheEntry parent = this.queryProcessor.listening.firstParentNotDiscarded(entry);
                if (parent == null) {
                    boolean collected = this.tryCollect(entry);
                    if (!collected) {
                        entry.setLevel((short)0);
                    }
                } else {
                    this.queryProcessor.listening.pruneParentSet(entry);
                    short nextLevel = parent.getLevel();
                    nextLevel = (short)(nextLevel + 1);
                    this.support.setLevel(entry, nextLevel);
                }
                ++i;
            }
            break;
        }
    }

    private boolean tryCollect(CacheEntry entry) {
        if (!this.queryProcessor.listening.hasListenerAfterDisposing(entry) && entry.shouldBeCollected()) {
            this.queryProcessor.removeQuery(entry);
            this.support.remove();
            this.propagate = true;
            ++this.moreAll;
            this.doneAll = false;
            return true;
        }
        return false;
    }

    private void start() {
        this.moreAll = 1;
        this.doneAll = false;
    }
}

