/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.utils;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.Literals;
import org.simantics.db.common.utils.Versions;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.MapList;

public final class NameUtils {
    public static final Comparator<Object> STRING_CHARBUFFER_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = null;
            String s2 = null;
            if (o1 instanceof String) {
                s1 = (String)o1;
            }
            if (o2 instanceof String) {
                s2 = (String)o2;
            }
            if (s1 != null && s2 != null) {
                return s1.compareTo((String)o2);
            }
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null && o1 instanceof CharBuffer) {
                return -this.compare(s2, (CharBuffer)o1);
            }
            if (s2 == null && o2 instanceof CharBuffer) {
                return this.compare(s1, (CharBuffer)o2);
            }
            return 0;
        }

        @Override
        int compare(String s, CharBuffer buf) {
            int len1 = s.length();
            int len2 = buf.position();
            int n = Math.min(len1, len2);
            int k = 0;
            while (k < n) {
                char c2;
                char c1 = s.charAt(k);
                if (c1 != (c2 = buf.get(k))) {
                    return c1 - c2;
                }
                ++k;
            }
            return len1 - len2;
        }
    };

    public static Set<String> findReservedNames(ReadGraph g, String proposition, Resource container, Resource consistRelation, Resource propertyToList, Set<String> result, MapList<String, String> reservation) throws DatabaseException {
        String possibleURI;
        if (proposition == null) {
            throw new NullPointerException("null proposition");
        }
        if (propertyToList == null) {
            throw new NullPointerException("null property to list");
        }
        if (result == null) {
            result = new HashSet<String>();
        }
        if (reservation != null && (possibleURI = g.getPossibleURI(container)) != null) {
            result.addAll(reservation.getValuesUnsafe((Object)possibleURI));
        }
        for (Resource r : g.getObjects(container, consistRelation)) {
            String name = (String)g.getPossibleRelatedValue(r, propertyToList);
            if (name == null || !name.startsWith(proposition)) continue;
            result.add(Versions.getBaseName(name));
        }
        return result;
    }

    public static Set<String> findReservedNames(ReadGraph g, String proposition, Resource container, Resource consistRelation, Resource propertyToList, Set<String> result) throws DatabaseException {
        return NameUtils.findReservedNames(g, proposition, container, consistRelation, propertyToList, result, null);
    }

    public static Set<String> findReservedNames(ReadGraph g, String proposition, Resource container, Resource consistRelation, Set<String> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        return NameUtils.findReservedNames(g, proposition, container, consistRelation, L0.HasName, result);
    }

    public static Set<String> findReservedNames(ReadGraph g, String proposition, Resource container, Resource consistRelation) throws DatabaseException {
        HashSet<String> result = new HashSet<String>();
        NameUtils.findReservedNames(g, proposition, container, consistRelation, result);
        return result;
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        return NameUtils.findFreshName(g, proposition, container, b.ConsistsOf);
    }

    public static String findFreshLabel(ReadGraph g, String proposition, Resource container) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        return NameUtils._findFreshName(g, proposition, container, L0.ConsistsOf, L0.HasLabel, " ");
    }

    public static String findFreshEscapedName(ReadGraph g, String proposition, Resource container) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        return NameUtils.findFreshEscapedName(g, proposition, container, b.ConsistsOf);
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation) throws DatabaseException {
        return NameUtils._findFreshName(g, proposition, container, consistRelation, " ");
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation, String nameFormat) throws DatabaseException {
        return NameUtils.findFreshName(g, proposition, container, consistRelation, Layer0.getInstance((ReadGraph)g).HasName, nameFormat);
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation, Resource nameProperty, String nameFormat) throws DatabaseException {
        TreeSet<Object> reservedNames = new TreeSet<Object>(STRING_CHARBUFFER_COMPARATOR);
        NameUtils.findReservedNames(g, proposition, container, consistRelation, nameProperty, reservedNames);
        return NameUtils.findFreshNameFormatted(proposition, reservedNames, nameFormat);
    }

    public static String findFreshEscapedName(ReadGraph g, String proposition, Resource container, Resource consistRelation) throws DatabaseException {
        return NameUtils._findFreshName(g, proposition, container, consistRelation, "_");
    }

    public static String findFreshName(ReadGraph g, String proposition, Set<String> reservedNames, String numberSeparator) throws DatabaseException {
        if (!reservedNames.contains(proposition)) {
            return proposition;
        }
        TreeSet<Object> used = new TreeSet<Object>(STRING_CHARBUFFER_COMPARATOR);
        used.addAll(reservedNames);
        return NameUtils.findFreshNameNumbered(proposition, used, numberSeparator);
    }

    public static String findFreshInstanceName(ReadGraph g, Resource type, Resource container) throws DatabaseException {
        String typeName = (String)g.getPossibleRelatedValue(type, Layer0.getInstance((ReadGraph)g).HasName);
        if (typeName == null) {
            typeName = "Entity";
        }
        return NameUtils.findFreshName(g, typeName, container);
    }

    public static String findFreshInstanceName(ReadGraph g, Resource type, Resource container, Resource relation) throws DatabaseException {
        String typeName = (String)g.getPossibleRelatedValue(type, Layer0.getInstance((ReadGraph)g).HasName);
        if (typeName == null) {
            typeName = "Entity";
        }
        return NameUtils.findFreshName(g, typeName, container, relation);
    }

    private static String _findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation, String numberSeparator) throws DatabaseException {
        return NameUtils._findFreshName(g, proposition, container, consistRelation, Layer0.getInstance((ReadGraph)g).HasName, numberSeparator);
    }

    private static String _findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation, Resource nameProperty, String numberSeparator) throws DatabaseException {
        return NameUtils.findFreshName(g, proposition, container, consistRelation, nameProperty, numberSeparator, null);
    }

    public static String findFreshName(ReadGraph g, String proposition, Resource container, Resource consistRelation, Resource nameProperty, String numberSeparator, MapList<String, String> reservation) throws DatabaseException {
        TreeSet<Object> reservedNames = new TreeSet<Object>(STRING_CHARBUFFER_COMPARATOR);
        NameUtils.findReservedNames(g, proposition, container, consistRelation, nameProperty, reservedNames, reservation);
        return NameUtils.findFreshNameNumbered(proposition, reservedNames, numberSeparator);
    }

    private static Set<String> ensureTreeSetWithComparator(Set<String> s) {
        if (!(s instanceof TreeSet) || ((TreeSet)s).comparator() != STRING_CHARBUFFER_COMPARATOR) {
            TreeSet<Object> ts = new TreeSet<Object>(STRING_CHARBUFFER_COMPARATOR);
            ts.addAll(s);
            return ts;
        }
        return s;
    }

    public static String findFreshNameNumbered(String proposition, Set<String> reservedNames, String numberSeparator) {
        if (!reservedNames.contains(proposition)) {
            return proposition;
        }
        reservedNames = NameUtils.ensureTreeSetWithComparator(reservedNames);
        CharBuffer cb = CharBuffer.allocate(proposition.length() + 10);
        cb.append(proposition);
        cb.append(numberSeparator);
        cb.mark();
        int i = reservedNames.size() + 1;
        while (true) {
            cb.reset();
            cb.append(String.valueOf(i));
            if (!reservedNames.contains(cb)) {
                cb.limit(cb.position());
                cb.rewind();
                return cb.toString();
            }
            ++i;
        }
    }

    public static String findFreshNameFormatted(String proposition, Set<String> reservedNames, String nameFormat) {
        if (!reservedNames.contains(proposition)) {
            return proposition;
        }
        reservedNames = NameUtils.ensureTreeSetWithComparator(reservedNames);
        CharBuffer cb = CharBuffer.allocate(proposition.length() + 10);
        cb.mark();
        Formatter formatter = new Formatter(cb, Locale.US);
        int i = reservedNames.size() + 1;
        while (true) {
            cb.reset();
            formatter.format(nameFormat, proposition, i);
            if (!reservedNames.contains(cb)) {
                cb.limit(cb.position());
                cb.rewind();
                String result = cb.toString();
                return result;
            }
            ++i;
        }
    }

    public static String getSafeName(ReadGraph graph, Resource resource, boolean id) throws ValidationException, ServiceException {
        if (id && resource != null) {
            return NameUtils.getSafeName(graph, resource) + ":$" + resource.getResourceId();
        }
        return NameUtils.getSafeName(graph, resource);
    }

    public static String getSafeName(ReadGraph graph, Collection<Resource> rs) throws ValidationException, ServiceException {
        StringBuilder b = new StringBuilder();
        b.append("{");
        for (Resource r : rs) {
            b.append(NameUtils.getSafeName(graph, r));
            b.append(",");
        }
        b.append("}");
        return b.toString();
    }

    public static String getSafeLabel(ReadGraph graph, Resource resource) throws ValidationException, ServiceException {
        return NameUtils.getSafeNameInternal(graph, resource, true);
    }

    public static String getSafeName(ReadGraph graph, Resource resource) throws ValidationException, ServiceException {
        return NameUtils.getSafeNameInternal(graph, resource, false);
    }

    private static Object truncate(Object array) {
        byte[] bytes;
        if (array instanceof byte[] && (bytes = (byte[])array).length > 100) {
            return Arrays.copyOfRange(bytes, 0, 100);
        }
        return array;
    }

    public static String getURIOrSafeNameInternal(ReadGraph graph, Resource resource) throws ValidationException, ServiceException {
        return NameUtils.getURIOrSafeNameInternal(graph, resource, false);
    }

    public static String getURIOrSafeNameInternal(ReadGraph graph, Resource resource, boolean tryLabel) throws ValidationException, ServiceException {
        if (resource == null) {
            return "null";
        }
        String uri = graph.getPossibleURI(resource);
        if (uri != null) {
            return uri;
        }
        return NameUtils.getSafeNameInternal(graph, resource, tryLabel);
    }

    public static long getPossibleValueSize(ReadGraph graph, Resource resource) {
        try {
            if (graph.hasValue(resource)) {
                RandomAccessBinary rab = graph.getRandomAccessBinary(resource);
                return rab.length();
            }
        }
        catch (Exception exception) {}
        return 0L;
    }

    private static String getSafeNameInternal(ReadGraph graph, Resource resource, boolean tryLabel) throws ValidationException, ServiceException {
        StringBuilder bb;
        Object value;
        if (resource == null) {
            return "null";
        }
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, b.Variant)) {
            try {
                Variant v = (Variant)graph.getPossibleValue(resource, (Binding)Bindings.VARIANT);
                return v.toString();
            }
            catch (BindingException bindingException) {}
        }
        ArrayList<String> names = new ArrayList<String>(1);
        if (tryLabel) {
            for (Resource nameResource : graph.getObjects(resource, b.HasLabel)) {
                String s;
                if (!graph.isInstanceOf(nameResource, b.Literal) || (value = graph.getPossibleValue(nameResource)) == null || (s = Literals.literalToString(value)).isEmpty()) continue;
                names.add(s);
            }
        }
        if (names.isEmpty()) {
            for (Resource nameResource : graph.getObjects(resource, b.HasName)) {
                value = graph.getPossibleValue(nameResource);
                if (value == null) continue;
                names.add(Literals.literalToString(value));
            }
        }
        if (!names.isEmpty()) {
            if (names.size() == 1) {
                return (String)names.get(0);
            }
            bb = new StringBuilder();
            bb.append('[');
            int i = 0;
            while (i < names.size()) {
                if (i > 0) {
                    bb.append(", ");
                }
                bb.append((String)names.get(i));
                ++i;
            }
            bb.append(']');
            return bb.toString();
        }
        bb = new StringBuilder();
        long valueSize = NameUtils.getPossibleValueSize(graph, resource);
        if (valueSize > 0L) {
            if ((double)valueSize < 1000000.0) {
                Object val = graph.getPossibleValue(resource);
                if (val != null) {
                    if ((val = NameUtils.truncate(val)) instanceof double[]) {
                        bb.append(Arrays.toString((double[])val));
                    } else if (val instanceof float[]) {
                        bb.append(Arrays.toString((float[])val));
                    } else if (val instanceof int[]) {
                        bb.append(Arrays.toString((int[])val));
                    } else if (val instanceof boolean[]) {
                        bb.append(Arrays.toString((boolean[])val));
                    } else if (val instanceof long[]) {
                        bb.append(Arrays.toString((long[])val));
                    } else if (val instanceof byte[]) {
                        bb.append(Arrays.toString((byte[])val));
                    } else if (val instanceof String[]) {
                        bb.append(Arrays.toString((String[])val));
                    } else {
                        bb.append(val);
                    }
                } else {
                    bb.append('$').append(resource.getResourceId());
                }
            } else {
                bb.append('$').append(resource.getResourceId());
                bb.append("[" + valueSize + " bytes of value]");
            }
        } else {
            bb.append('$').append(resource.getResourceId());
        }
        boolean ok = false;
        for (Resource r : graph.getObjects(resource, b.InstanceOf)) {
            if (!r.equals(resource)) {
                bb.append(" : (" + NameUtils.getSafeName(graph, r) + ")");
            }
            ok = true;
        }
        if (!ok) {
            for (Resource r : graph.getObjects(resource, b.Inherits)) {
                bb.append(" <T (" + NameUtils.getSafeName(graph, r) + ")");
                ok = true;
            }
            if (!ok) {
                for (Resource r : graph.getObjects(resource, b.SubrelationOf)) {
                    bb.append(" <R (" + NameUtils.getSafeName(graph, r) + ")");
                    ok = true;
                }
            }
        }
        return bb.toString();
    }

    public static String toString(ReadGraph graph, Statement stm) throws DatabaseException {
        return NameUtils.getSafeName(graph, stm.getSubject()) + ", " + NameUtils.getSafeName(graph, stm.getPredicate()) + ", " + NameUtils.getSafeName(graph, stm.getObject());
    }

    public static String toString(ReadGraph graph, Statement stm, boolean ids) throws DatabaseException {
        return NameUtils.getSafeName(graph, stm.getSubject(), ids) + ", " + NameUtils.getSafeName(graph, stm.getPredicate(), ids) + ", " + NameUtils.getSafeName(graph, stm.getObject(), ids);
    }

    public static String toIdString(ReadGraph graph, Statement stm) throws DatabaseException {
        return String.valueOf(stm.getSubject()) + ", " + String.valueOf(stm.getPredicate()) + ", " + String.valueOf(stm.getObject());
    }

    public static String toString(ReadGraph g, Collection<Resource> c) throws DatabaseException {
        return NameUtils.toString(g, c, false);
    }

    public static String toString(ReadGraph g, Collection<Resource> c, boolean ids) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean first = true;
        for (Resource r : c) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(NameUtils.getSafeName(g, r, ids));
        }
        return sb.append(']').toString();
    }

    public static String resourcePath(ReadGraph graph, Resource r) throws DatabaseException {
        return NameUtils.resourcePath0(graph, r, new StringBuilder(80)).toString();
    }

    private static StringBuilder resourcePath0(ReadGraph graph, Resource r, StringBuilder result) throws DatabaseException {
        String uri = graph.getPossibleURI(r);
        if (uri != null) {
            return result.append(uri);
        }
        Resource owner = null;
        try {
            owner = CommonDBUtils.getPossibleOwner(graph, r);
            if (owner == null) {
                return result.append(NameUtils.getSafeName(graph, r));
            }
        }
        catch (DatabaseException databaseException) {
            return result.append(NameUtils.getSafeName(graph, r));
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Statement stm : graph.getStatements(owner, L0.IsWeaklyRelatedTo)) {
            if (!stm.getObject().equals(r)) continue;
            Resource predicate = stm.getPredicate();
            if (predicate.equals(L0.ConsistsOf)) {
                return NameUtils.resourcePath0(graph, owner, result).append(" / ").append(NameUtils.getSafeName(graph, r));
            }
            if (graph.isSubrelationOf(predicate, L0.HasProperty)) {
                return NameUtils.resourcePath0(graph, owner, result).append(" #(").append(NameUtils.getSafeName(graph, predicate, true)).append(") ").append(NameUtils.getSafeName(graph, r));
            }
            return NameUtils.resourcePath0(graph, owner, result).append(" -(").append(NameUtils.getSafeName(graph, predicate, true)).append(")-> ").append(NameUtils.getSafeName(graph, r));
        }
        return NameUtils.resourcePath0(graph, owner, result).append(" ... ").append(NameUtils.getSafeName(graph, r));
    }

    public static String rootRelativeURI(ReadGraph graph, Resource root, Resource r, boolean includeRoot, boolean escaped) throws DatabaseException {
        if (root != null) {
            String rootUri = graph.getPossibleURI(root);
            String uri = graph.getPossibleURI(r);
            if (rootUri != null && uri != null && uri.startsWith(rootUri)) {
                int rul = rootUri.length();
                if (includeRoot) {
                    int previousSlash = rootUri.lastIndexOf(47);
                    String result = uri.substring(previousSlash >= 0 ? previousSlash + 1 : rul + 1);
                    return escaped ? result : URIStringUtils.unescape((String)result);
                }
                String result = uri.substring(rul + 1);
                return escaped ? result : URIStringUtils.unescape((String)result);
            }
        }
        return NameUtils.getURIOrSafeNameInternal(graph, r);
    }

    public static String rootRelativeURI(ReadGraph graph, Resource r, boolean includeRoot, boolean escaped) throws DatabaseException {
        Resource root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(r));
        return NameUtils.rootRelativeURI(graph, root, r, includeRoot, escaped);
    }
}

