/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;

public class Adapt<T>
extends ResourceRead<T> {
    protected final Class<T> target;
    protected final boolean allowNull;
    protected final boolean uniqueResult;

    public Adapt(Resource resource, Class<T> target) {
        this(resource, target, false, false);
    }

    public Adapt(Resource resource, Class<T> target, boolean allowNull) {
        this(resource, target, allowNull, false);
    }

    public Adapt(Resource resource, Class<T> target, boolean allowNull, boolean uniqueResult) {
        super(resource);
        assert (target != null);
        this.target = target;
        this.allowNull = allowNull;
        this.uniqueResult = uniqueResult;
    }

    public T perform(ReadGraph graph) throws AdaptionException, ValidationException, ServiceException {
        if (this.allowNull) {
            if (this.uniqueResult) {
                return (T)graph.getPossibleUniqueAdapter(this.resource, this.target);
            }
            return (T)graph.getPossibleAdapter(this.resource, this.target);
        }
        if (this.uniqueResult) {
            return (T)graph.adaptUnique(this.resource, this.target);
        }
        return (T)graph.adapt(this.resource, this.target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.allowNull ? 1231 : 1237);
        result = 31 * result + this.target.hashCode();
        result = 31 * result + (this.uniqueResult ? 1303 : 1319);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Adapt other = (Adapt)obj;
        if (!this.resource.equals(other.resource)) {
            return false;
        }
        if (this.allowNull != other.allowNull) {
            return false;
        }
        if (!this.target.equals(other.target)) {
            return false;
        }
        return this.uniqueResult == other.uniqueResult;
    }
}

