/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;

public class ResourceArray
implements Iterable<Resource> {
    public static final ResourceArray[] NONE = new ResourceArray[0];
    public static final ResourceArray EMPTY = new ResourceArray(new Resource[0]);
    public final Resource[] resources;
    private int hash;

    private boolean noNulls(Resource[] rs) {
        Resource[] resourceArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (r == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean noNulls(Collection<Resource> rs) {
        for (Resource r : rs) {
            if (r != null) continue;
            return false;
        }
        return true;
    }

    public ResourceArray(Resource ... resources) {
        assert (this.noNulls(resources));
        this.resources = resources;
        this.hash = Arrays.hashCode(resources);
    }

    public ResourceArray(Collection<Resource> resources) {
        assert (this.noNulls(resources));
        this.resources = resources.toArray(new Resource[resources.size()]);
        this.hash = Arrays.hashCode(this.resources);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceArray)) {
            return false;
        }
        ResourceArray other = (ResourceArray)obj;
        return Arrays.deepEquals(this.resources, other.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.resources.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.resources[i].getResourceId());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString(ReadGraph g) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < this.resources.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(NameUtils.getSafeName(g, this.resources[i]));
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static ResourceArray[] toSingleElementArrays(Resource[] array) {
        ResourceArray[] result = new ResourceArray[array.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new ResourceArray(array[i]);
            ++i;
        }
        return result;
    }

    public Resource toSingleResource() throws ValidationException {
        if (this.resources.length != 1) {
            throw new ValidationException("Resource array did not contain a single resource (contained " + this.resources.length + ").");
        }
        return this.resources[0];
    }

    public boolean isEmpty() {
        return this.resources.length == 0;
    }

    public int size() {
        return this.resources.length;
    }

    public Resource get(int i) {
        return this.resources[i];
    }

    @Override
    public Iterator<Resource> iterator() {
        return Arrays.asList(this.resources).iterator();
    }

    public ResourceArray appended(Resource ... append) {
        if (append.length == 0) {
            return this;
        }
        Resource[] result = Arrays.copyOf(this.resources, this.resources.length + append.length);
        System.arraycopy(append, 0, result, this.resources.length, append.length);
        return new ResourceArray(result);
    }

    public ResourceArray appended(ResourceArray append) {
        if (append.size() == 0) {
            return this;
        }
        Resource[] result = Arrays.copyOf(this.resources, this.resources.length + append.size());
        System.arraycopy(append.resources, 0, result, this.resources.length, append.size());
        return new ResourceArray(result);
    }

    public ResourceArray prepended(Resource ... prepend) {
        if (prepend.length == 0) {
            return this;
        }
        Resource[] result = Arrays.copyOf(prepend, prepend.length + this.resources.length);
        System.arraycopy(this.resources, 0, result, prepend.length, this.resources.length);
        return new ResourceArray(result);
    }

    public ResourceArray removeFromBeginning(int n) throws IllegalArgumentException {
        return this.slice(n, this.resources.length);
    }

    public ResourceArray removeFromEnd(int n) throws IllegalArgumentException {
        return this.slice(0, this.resources.length - n);
    }

    public ResourceArray slice(int start, int end) {
        return start == 0 && end == this.resources.length ? this : new ResourceArray(Arrays.copyOfRange(this.resources, start, end));
    }

    public ResourceArray reversed() {
        if (this.resources.length < 2) {
            return this;
        }
        Resource[] result = new Resource[this.resources.length];
        int i = 0;
        while (i < this.resources.length) {
            result[i] = this.resources[this.resources.length - 1 - i];
            ++i;
        }
        return new ResourceArray(result);
    }

    public Resource tail() {
        return this.resources[this.resources.length - 1];
    }

    public Resource head() {
        return this.resources[0];
    }
}

