package org.simantics.db.common.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NearestOwnerFinder;
import org.simantics.db.exception.DatabaseException;

public class PossibleOwner extends ResourceRead<Resource> {

    public PossibleOwner(Resource resource) {
        super(resource);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
        return NearestOwnerFinder.getNearestOwner(graph, resource);
    }
    
}