/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

final public class ObjectsWithType extends ResourceRead3<Collection<Resource>> {

    public ObjectsWithType(Resource subject, Resource subrelationOf, Resource instanceOf) {
        super(subject, subrelationOf, instanceOf);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        
    	Set<Resource> result = new HashSet<Resource>();
    	for(Resource object : graph.getObjects(resource, resource2)) {
    		if(graph.isInstanceOf(object, resource3)) result.add(object);
    	}
    	return result;
        
    }

}
