/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.common.request;

import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;

public class MappedTypedParts extends ResourceRead2<Map<Resource, Resource>> {

    public MappedTypedParts(Resource realization, Resource type) {
        super(realization, type);
    }
    
    @Override
    public Map<Resource, Resource> perform(ReadGraph graph) throws DatabaseException {
        
        Layer0 l0 = Layer0.getInstance(graph);
        Layer0X L0X = Layer0X.getInstance(graph);
        Map<Resource, Resource> result = new HashMap<Resource, Resource>();
        
        for(Resource part : graph.syncRequest(new ObjectsWithType(resource, l0.ConsistsOf, resource2))) {
        	Resource represents = graph.getPossibleObject(part, L0X.Represents);
        	if(represents != null) result.put(represents, part);
        }
        
        return result;
        
    }

}
